@extends('layouts.admin') {{-- Or your main admin layout if different --}}

@section('title', 'Business Directory Dashboard')
@section('header_title', 'Business Directory Dashboard')

@section('content')
<div class="p-6">
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        {{-- Stat Card: Total Companies --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-blue-500 dark:bg-blue-700 rounded-md p-3">
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">
                                Total Companies
                            </dt>
                            <dd class="text-2xl font-semibold text-gray-900 dark:text-white">
                                {{ $companyCount ?? 0 }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.businessdirectory.companies.index') }}" class="font-medium text-blue-600 dark:text-blue-400 hover:text-blue-500 dark:hover:text-blue-300">
                        View all
                    </a>
                </div>
            </div>
        </div>
        {{-- Stat Card: Pending Companies --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-yellow-500 dark:bg-yellow-700 rounded-md p-3">
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">
                                Pending Approval
                            </dt>
                            <dd class="text-2xl font-semibold text-gray-900 dark:text-white">
                                {{ $pendingCompanyCount ?? 0 }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.businessdirectory.companies.index', ['status' => 'pending']) }}" class="font-medium text-yellow-600 dark:text-yellow-400 hover:text-yellow-500 dark:hover:text-yellow-300">
                        View pending
                    </a>
                </div>
            </div>
        </div>

        {{-- Stat Card: Active Tenders --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-green-500 dark:bg-green-700 rounded-md p-3">
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">
                                Active Tenders
                            </dt>
                            <dd class="text-2xl font-semibold text-gray-900 dark:text-white">
                                {{ $activeTenderCount ?? 0 }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.businessdirectory.tenders.index', ['status' => 'open']) }}" class="font-medium text-green-600 dark:text-green-400 hover:text-green-500 dark:hover:text-green-300">
                        View all
                    </a>
                </div>
            </div>
        </div>
        
        {{-- Stat Card: Total Products (Consider if this should be global or per-company) --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-purple-500 dark:bg-purple-700 rounded-md p-3">
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">
                                Total Products
                            </dt>
                            <dd class="text-2xl font-semibold text-gray-900 dark:text-white">
                                {{ $productCount ?? 0 }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    {{-- This link might need to go to a global product management page if you implement one --}}
                    <a href="#" class="font-medium text-purple-600 dark:text-purple-400 hover:text-purple-500 dark:hover:text-purple-300">
                        Manage Products
                    </a>
                </div>
            </div>
        </div>

        {{-- Stat Card: Pending Reviews --}}
        <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-lg rounded-lg">
            <div class="p-5">
                <div class="flex items-center">
                    <div class="flex-shrink-0 bg-pink-500 dark:bg-pink-700 rounded-md p-3">
                        <svg class="h-6 w-6 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                           <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z" />
                        </svg>
                    </div>
                    <div class="ml-5 w-0 flex-1">
                        <dl>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">
                                Pending Reviews
                            </dt>
                            <dd class="text-2xl font-semibold text-gray-900 dark:text-white">
                                {{ $pendingReviewCount ?? 0 }}
                            </dd>
                        </dl>
                    </div>
                </div>
            </div>
            <div class="bg-gray-50 dark:bg-gray-700 px-5 py-3">
                <div class="text-sm">
                    <a href="{{ route('admin.businessdirectory.reviews.index', ['status_filter' => '0']) }}" class="font-medium text-pink-600 dark:text-pink-400 hover:text-pink-500 dark:hover:text-pink-300">
                        Manage Reviews
                    </a>
                </div>
            </div>
        </div>

    </div>

    <div class="mt-8">
        <h2 class="text-xl font-semibold text-gray-700 dark:text-gray-300 mb-4">Quick Links</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <a href="{{ route('admin.businessdirectory.companies.create') }}" class="block p-4 bg-white dark:bg-gray-700 shadow rounded-lg hover:bg-gray-50 dark:hover:bg-gray-600 transition ease-in-out duration-150">
                <h3 class="font-medium text-gray-900 dark:text-white">Add New Company</h3>
                <p class="text-sm text-gray-500 dark:text-gray-400">Register a new business listing.</p>
            </a>
            <a href="{{ route('admin.businessdirectory.categories.index') }}" class="block p-4 bg-white dark:bg-gray-700 shadow rounded-lg hover:bg-gray-50 dark:hover:bg-gray-600 transition ease-in-out duration-150">
                <h3 class="font-medium text-gray-900 dark:text-white">Manage Categories</h3>
                <p class="text-sm text-gray-500 dark:text-gray-400">Organize business categories.</p>
            </a>
            <a href="{{ route('admin.businessdirectory.company-types.index') }}" class="block p-4 bg-white dark:bg-gray-700 shadow rounded-lg hover:bg-gray-50 dark:hover:bg-gray-600 transition ease-in-out duration-150">
                <h3 class="font-medium text-gray-900 dark:text-white">Manage Company Types</h3>
                <p class="text-sm text-gray-500 dark:text-gray-400">Define types of businesses.</p>
            </a>
            <a href="{{ route('admin.businessdirectory.tenders.create') }}" class="block p-4 bg-white dark:bg-gray-700 shadow rounded-lg hover:bg-gray-50 dark:hover:bg-gray-600 transition ease-in-out duration-150">
                <h3 class="font-medium text-gray-900 dark:text-white">Add New Tender</h3>
                <p class="text-sm text-gray-500 dark:text-gray-400">Post a new project or service requirement.</p>
            </a>
            <a href="{{ route('admin.businessdirectory.jobs.create') }}" class="block p-4 bg-white dark:bg-gray-700 shadow rounded-lg hover:bg-gray-50 dark:hover:bg-gray-600 transition ease-in-out duration-150">
                <h3 class="font-medium text-gray-900 dark:text-white">Post New Job</h3>
                <p class="text-sm text-gray-500 dark:text-gray-400">Create a new job listing.</p>
            </a>
            <a href="{{ route('admin.businessdirectory.settings.edit') }}" class="block p-4 bg-white dark:bg-gray-700 shadow rounded-lg hover:bg-gray-50 dark:hover:bg-gray-600 transition ease-in-out duration-150">
                <h3 class="font-medium text-gray-900 dark:text-white">Module Settings</h3>
                <p class="text-sm text-gray-500 dark:text-gray-400">Configure Business Directory options.</p>
            </a>
        </div>
    </div>

</div>
@endsection