@extends('layouts.admin') {{-- Or your main admin layout --}}

@section('title', 'Create New Company Type')

@section('content')
<div class="px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-200">Create New Company Type</h1>
        <a href="{{ route('admin.businessdirectory.company-types.index') }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
            &larr; Back to Company Types
        </a>
    </div>
    <div class="max-w-3xl mx-auto">
        <div class="bg-white dark:bg-gray-800 shadow-md rounded-lg">
                <form action="{{ route('admin.businessdirectory.company-types.store') }}" method="POST" enctype="multipart/form-data"> {{-- Added enctype --}}
                    @include('businessdirectory::admin.company_types._form', ['companyType' => new \Modules\BusinessDirectory\Entities\CompanyType()])
                </form>
        </div>
    </div>
</div>
@endsection