@csrf
<div class="grid grid-cols-1 gap-6">
    <div>
        <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company Type Name</label>
        <input type="text" name="name" id="name" value="{{ old('name', $companyType->name) }}" required
               class="mt-1 block w-full input-style @error('name') border-red-500 @enderror">
        @error('name') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
    </div>

    <div>
        <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description (Optional)</label>
        <textarea name="description" id="description" rows="4"
                  class="mt-1 block w-full input-style @error('description') border-red-500 @enderror">{{ old('description', $companyType->description) }}</textarea>
        @error('description') <p class="mt-1 text-sm text-red-500">{{ $message }}</p> @enderror
    </div>
</div>

<div class="mt-8 flex justify-end">
    <a href="{{ route('admin.businessdirectory.company-types.index') }}" class="btn-secondary mr-4">
        Cancel
    </a>
    <button type="submit" class="btn-primary">
        {{ $companyType->exists ? 'Update' : 'Create' }} Company Type
    </button>
</div>