@csrf
<div class="p-6 space-y-8">
    {{-- Basic Information Section --}}
    <div class="space-y-6">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-white">Basic Information</h3>
        <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
            <div class="sm:col-span-4">
                <label for="name" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company Name <span class="text-red-500">*</span></label>
                <input type="text" name="name" id="name" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('name') border-red-500 @enderror" value="{{ old('name', $company->name ?? '') }}" required>
                @error('name') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>

            <div class="sm:col-span-2">
                <label for="user_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Owner/User</label>
                <select id="user_id" name="user_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('user_id') border-red-500 @enderror">
                    <option value="">Select User (Optional)</option>
                    @foreach($users as $id => $userName)
                        <option value="{{ $id }}" {{ (old('user_id', $company->user_id ?? '') == $id) ? 'selected' : '' }}>{{ $userName }}</option>
                    @endforeach
                </select>
                @error('user_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>

            <div class="sm:col-span-3">
                <label for="company_type_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Company Type</label>
                <select id="company_type_id" name="company_type_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('company_type_id') border-red-500 @enderror">
                    <option value="">Select Type</option>
                    @foreach($companyTypes as $id => $typeName)
                        <option value="{{ $id }}" {{ (old('company_type_id', $company->company_type_id ?? '') == $id) ? 'selected' : '' }}>{{ $typeName }}</option>
                    @endforeach
                </select>
                @error('company_type_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>

            <div class="sm:col-span-3">
                <label for="category_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Category</label>
                <select id="category_id" name="category_id" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('category_id') border-red-500 @enderror">
                    <option value="">Select Category</option>
                    @foreach($categories as $id => $categoryName)
                        <option value="{{ $id }}" {{ (old('category_id', $company->category_id ?? '') == $id) ? 'selected' : '' }}>{{ $categoryName }}</option>
                    @endforeach
                </select>
                @error('category_id') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>

            <div class="sm:col-span-6">
                <label for="description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Description <span class="text-red-500">*</span></label>
                <textarea id="description" name="description" rows="4" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('description') border-red-500 @enderror" required>{{ old('description', $company->description ?? '') }}</textarea>
                @error('description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>

            <div class="sm:col-span-3">
                <label for="logo" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Logo</label>
                <input type="file" name="logo" id="logo" class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-300 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 dark:file:bg-gray-600 file:text-indigo-700 dark:file:text-indigo-300 hover:file:bg-indigo-100 dark:hover:file:bg-gray-500 @error('logo') border-red-500 @enderror">
                @error('logo') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                @if(isset($company) && $company->logo_url && $company->logo_url !== asset('path/to/default-logo.png'))
                    <div class="mt-2">
                        <img src="{{ $company->logo_url }}" alt="Current Logo" class="h-20 w-auto rounded-md object-contain">
                         <div class="mt-1 flex items-center">
                            <input type="checkbox" name="remove_logo" id="remove_logo" class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500" value="1">
                            <label for="remove_logo" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Remove logo on save</label>
                        </div>
                    </div>
                @endif
            </div>

            <div class="sm:col-span-3">
                <label for="banner" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Banner Image</label>
                <input type="file" name="banner" id="banner" class="mt-1 block w-full text-sm text-gray-500 dark:text-gray-300 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-indigo-50 dark:file:bg-gray-600 file:text-indigo-700 dark:file:text-indigo-300 hover:file:bg-indigo-100 dark:hover:file:bg-gray-500 @error('banner') border-red-500 @enderror">
                @error('banner') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
                 @if(isset($company) && $company->banner_url && $company->banner_url !== asset('path/to/default-banner.png'))
                    <div class="mt-2">
                        <img src="{{ $company->banner_url }}" alt="Current Banner" class="h-20 w-auto rounded-md object-contain">
                         <div class="mt-1 flex items-center">
                            <input type="checkbox" name="remove_banner" id="remove_banner" class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500" value="1">
                            <label for="remove_banner" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Remove banner on save</label>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <hr class="border-gray-200 dark:border-gray-700">

    {{-- Contact Information Section --}}
    <div class="space-y-6">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-white">Contact Information</h3>
        <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
            <div class="sm:col-span-3">
                <label for="email" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Email Address <span class="text-red-500">*</span></label>
                <input type="email" name="email" id="email" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('email') border-red-500 @enderror" value="{{ old('email', $company->email ?? '') }}" required>
                @error('email') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-3">
                <label for="phone_number" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Phone Number</label>
                <input type="text" name="phone_number" id="phone_number" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('phone_number') border-red-500 @enderror" value="{{ old('phone_number', $company->phone_number ?? '') }}">
                @error('phone_number') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-3">
                <label for="website_url" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Website URL</label>
                <input type="url" name="website_url" id="website_url" placeholder="https://example.com" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('website_url') border-red-500 @enderror" value="{{ old('website_url', $company->website_url ?? '') }}">
                @error('website_url') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
             <div class="sm:col-span-3">
                <label for="whatsapp_number" class="block text-sm font-medium text-gray-700 dark:text-gray-300">WhatsApp Number</label>
                <input type="text" name="whatsapp_number" id="whatsapp_number" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('whatsapp_number') border-red-500 @enderror" value="{{ old('whatsapp_number', $company->whatsapp_number ?? '') }}">
                @error('whatsapp_number') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
        </div>
    </div>

    <hr class="border-gray-200 dark:border-gray-700">

    {{-- Address Section --}}
    <div class="space-y-6">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-white">Address</h3>
        <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
            <div class="sm:col-span-6">
                <label for="address_line_1" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Address Line 1</label>
                <input type="text" name="address_line_1" id="address_line_1" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('address_line_1') border-red-500 @enderror" value="{{ old('address_line_1', $company->address_line_1 ?? '') }}">
                @error('address_line_1') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-6">
                <label for="address_line_2" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Address Line 2 (Optional)</label>
                <input type="text" name="address_line_2" id="address_line_2" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('address_line_2') border-red-500 @enderror" value="{{ old('address_line_2', $company->address_line_2 ?? '') }}">
                @error('address_line_2') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-2">
                <label for="city" class="block text-sm font-medium text-gray-700 dark:text-gray-300">City</label>
                <input type="text" name="city" id="city" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('city') border-red-500 @enderror" value="{{ old('city', $company->city ?? '') }}">
                @error('city') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-2">
                <label for="state_province" class="block text-sm font-medium text-gray-700 dark:text-gray-300">State / Province</label>
                <input type="text" name="state_province" id="state_province" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('state_province') border-red-500 @enderror" value="{{ old('state_province', $company->state_province ?? '') }}">
                @error('state_province') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-2">
                <label for="postal_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300">ZIP / Postal Code</label>
                <input type="text" name="postal_code" id="postal_code" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('postal_code') border-red-500 @enderror" value="{{ old('postal_code', $company->postal_code ?? '') }}">
                @error('postal_code') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
             <div class="sm:col-span-2">
                <label for="country_code" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Country</label>
                {{-- Consider using a select dropdown for countries --}}
                <input type="text" name="country_code" id="country_code" placeholder="e.g. US, GB" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('country_code') border-red-500 @enderror" value="{{ old('country_code', $company->country_code ?? '') }}">
                @error('country_code') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-2">
                <label for="latitude" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Latitude</label>
                <input type="text" name="latitude" id="latitude" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('latitude') border-red-500 @enderror" value="{{ old('latitude', $company->latitude ?? '') }}">
                @error('latitude') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-2">
                <label for="longitude" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Longitude</label>
                <input type="text" name="longitude" id="longitude" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('longitude') border-red-500 @enderror" value="{{ old('longitude', $company->longitude ?? '') }}">
                @error('longitude') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
        </div>
    </div>

    <hr class="border-gray-200 dark:border-gray-700">

    {{-- Additional Details Section --}}
    <div class="space-y-6">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-white">Additional Details</h3>
        <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
            <div class="sm:col-span-2">
                <label for="established_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Established Date</label>
                <input type="date" name="established_date" id="established_date" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('established_date') border-red-500 @enderror" value="{{ old('established_date', isset($company->established_date) ? $company->established_date->format('Y-m-d') : '') }}">
                @error('established_date') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-2">
                <label for="employee_count" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Employee Count</label>
                <input type="text" name="employee_count" id="employee_count" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('employee_count') border-red-500 @enderror" value="{{ old('employee_count', $company->employee_count ?? '') }}">
                @error('employee_count') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-2">
                <label for="annual_revenue" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Annual Revenue</label>
                <input type="number" step="0.01" name="annual_revenue" id="annual_revenue" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('annual_revenue') border-red-500 @enderror" value="{{ old('annual_revenue', $company->annual_revenue ?? '') }}">
                @error('annual_revenue') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>

            {{-- Social Links (Example for Facebook, extend as needed) --}}
            <div class="sm:col-span-3">
                <label for="social_links_facebook" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Facebook URL</label>
                <input type="url" name="social_links[facebook]" id="social_links_facebook" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('social_links.facebook') border-red-500 @enderror" value="{{ old('social_links.facebook', $company->social_links['facebook'] ?? '') }}">
                @error('social_links.facebook') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-3">
                <label for="social_links_twitter" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Twitter URL</label>
                <input type="url" name="social_links[twitter]" id="social_links_twitter" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('social_links.twitter') border-red-500 @enderror" value="{{ old('social_links.twitter', $company->social_links['twitter'] ?? '') }}">
                @error('social_links.twitter') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            {{-- Add more social links: linkedin, instagram etc. --}}

        </div>
    </div>

    <hr class="border-gray-200 dark:border-gray-700">

    {{-- SEO Information Section --}}
    <div class="space-y-6">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-white">SEO Information</h3>
        <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
            <div class="sm:col-span-6">
                <label for="meta_title" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Title</label>
                <input type="text" name="meta_title" id="meta_title" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_title') border-red-500 @enderror" value="{{ old('meta_title', $company->meta_title ?? '') }}">
                @error('meta_title') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-6">
                <label for="meta_description" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Description</label>
                <textarea name="meta_description" id="meta_description" rows="3" class="mt-1 form-textarea block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_description') border-red-500 @enderror">{{ old('meta_description', $company->meta_description ?? '') }}</textarea>
                @error('meta_description') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
            <div class="sm:col-span-6">
                <label for="meta_keywords" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Meta Keywords (comma-separated)</label>
                <input type="text" name="meta_keywords" id="meta_keywords" class="mt-1 form-input block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('meta_keywords') border-red-500 @enderror" value="{{ old('meta_keywords', $company->meta_keywords ?? '') }}">
                @error('meta_keywords') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>
        </div>
    </div>

    <hr class="border-gray-200 dark:border-gray-700">

    {{-- Status and Flags Section --}}
    <div class="space-y-6">
        <h3 class="text-lg font-medium leading-6 text-gray-900 dark:text-white">Status & Flags</h3>
        <div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-6">
            <div class="sm:col-span-2">
                <label for="status" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Status <span class="text-red-500">*</span></label>
                <select id="status" name="status" class="mt-1 form-select block w-full sm:text-sm rounded-md shadow-sm dark:bg-gray-700 dark:border-gray-600 dark:text-gray-300 @error('status') border-red-500 @enderror" required>
                    @foreach(\Modules\BusinessDirectory\Entities\Company::getStatuses() as $key => $value)
                        <option value="{{ $key }}" {{ (old('status', $company->status ?? 'pending') == $key) ? 'selected' : '' }}>{{ $value }}</option>
                    @endforeach
                </select>
                @error('status') <p class="mt-2 text-sm text-red-600 dark:text-red-400">{{ $message }}</p> @enderror
            </div>

            <div class="sm:col-span-4 flex items-end space-x-6">
                <div class="flex items-center">
                    <input id="is_featured" name="is_featured" type="checkbox" value="1" {{ old('is_featured', $company->is_featured ?? false) ? 'checked' : '' }} class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500">
                    <label for="is_featured" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Is Featured?</label>
                </div>
                <div class="flex items-center">
                    <input id="is_verified" name="is_verified" type="checkbox" value="1" {{ old('is_verified', $company->is_verified ?? false) ? 'checked' : '' }} class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500">
                    <label for="is_verified" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">Is Verified?</label>
                </div>
                 <div class="flex items-center">
                    <input id="is_ecommerce" name="is_ecommerce" type="checkbox" value="1" {{ old('is_ecommerce', $company->is_ecommerce ?? false) ? 'checked' : '' }} class="form-checkbox h-4 w-4 text-indigo-600 border-gray-300 dark:border-gray-600 rounded focus:ring-indigo-500">
                    <label for="is_ecommerce" class="ml-2 block text-sm text-gray-900 dark:text-gray-300">E-commerce Enabled?</label>
                </div>
            </div>
        </div>
    </div>

</div>

<div class="px-6 py-4 bg-gray-50 dark:bg-gray-700 text-right space-x-3">
    <a href="{{ route('admin.businessdirectory.companies.index') }}" class="inline-flex justify-center py-2 px-4 border border-gray-300 dark:border-gray-500 rounded-md shadow-sm text-sm font-medium text-gray-700 dark:text-gray-200 bg-white dark:bg-gray-600 hover:bg-gray-50 dark:hover:bg-gray-500 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
        Cancel
    </a>
    <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
        {{ isset($company) && $company->id ? 'Update Company' : 'Create Company' }}
    </button>
</div>

@push('scripts')
{{-- Add any specific JS for this form if needed --}}
{{-- Example: Initialize a rich text editor for description --}}
{{-- <script>
    // if (typeof ClassicEditor !== 'undefined') {
    //     ClassicEditor
    //         .create( document.querySelector( '#description' ) )
    //         .catch( error => {
    //             console.error( error );
    //         } );
    // }
</script> --}}
@endpush