<?php

namespace Modules\BusinessDirectory\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\BusinessDirectory\Entities\CompanyType; // Corrected model import

class CompanyTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $types = [
            ['name' => 'Software Development', 'description' => 'Companies specializing in custom software, web, and mobile application development.'],
            ['name' => 'Marketing Agency', 'description' => 'Firms offering digital marketing, SEO, content creation, and advertising services.'],
            ['name' => 'E-commerce Store', 'description' => 'Online retailers selling products directly to consumers or businesses.'],
            ['name' => 'Consulting Firm', 'description' => 'Businesses providing expert advice in various fields like management, IT, or finance.'],
            ['name' => 'Construction Company', 'description' => 'Companies involved in building and infrastructure projects.'],
            ['name' => 'Manufacturing', 'description' => 'Businesses that produce goods from raw materials or components.'],
            ['name' => 'Service Provider', 'description' => 'General category for businesses offering various services.'],
            ['name' => 'Real Estate Agency', 'description' => 'Agencies dealing with property sales, rentals, and management.'],
            ['name' => 'Healthcare Provider', 'description' => 'Hospitals, clinics, and individual practitioners offering medical services.'],
            ['name' => 'Educational Institution', 'description' => 'Schools, colleges, universities, and training centers.'],
        ];

        foreach ($types as $type) {
            CompanyType::updateOrCreate(
                ['slug' => \Illuminate\Support\Str::slug($type['name'])],
                $type
            );
        }

        $this->command->info('Business Directory: Company types seeded successfully.');
    }
}