<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bd_products', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained('bd_companies')->onDelete('cascade');
            $table->string('name');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->decimal('price', 10, 2);
            $table->string('sku')->nullable()->unique()->comment('Stock Keeping Unit');
            $table->integer('stock_quantity')->default(0);
            $table->boolean('is_published')->default(true);
            $table->json('images')->nullable()->comment('Array of image paths'); // For multiple images
            // You might want a separate product_categories table later
            // $table->foreignId('product_category_id')->nullable()->constrained('bd_product_categories')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bd_products');
    }
};