<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Tender;
use Modules\BusinessDirectory\Entities\Company;
use App\Entities\User; // Assuming global User model

class TenderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Tender::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $title = 'Seeking Proposals for: ' . $this->faker->bs;
        $budgetMin = $this->faker->optional(0.8)->numberBetween(500, 10000);
        return [
            'company_id' => Company::factory(),
            'user_id' => User::factory(), // User who created it, could be company owner or other
            'title' => $title,
            // slug will be auto-generated by the HasSlug trait in the Tender model
            'description' => $this->faker->paragraphs(4, true) . "\n\nKey Requirements:\n- " . $this->faker->sentence . "\n- " . $this->faker->sentence . "\n- " . $this->faker->sentence,
            'budget_min' => $budgetMin,
            'budget_max' => $budgetMin ? $this->faker->optional(0.8)->numberBetween($budgetMin + 1000, $budgetMin + 50000) : $this->faker->optional(0.6)->numberBetween(1000, 100000),
            'currency' => $this->faker->randomElement(['USD', 'EUR', 'GBP', 'KES', 'CAD', 'AUD']),
            'category_id' => $this->faker->optional()->numberBetween(1, 10), // Assuming you might have a categories table later (e.g., bd_tender_categories)
            'type' => $this->faker->randomElement(['fixed-price', 'hourly-rate', 'milestone-based', 'retainer']),
            'location' => $this->faker->optional(0.7)->city . ', ' . $this->faker->country, // 70% chance of having a location
            'deadline' => $this->faker->dateTimeBetween('+2 weeks', '+6 months'),
            'status' => $this->faker->randomElement(['open', 'evaluating_bids', 'awarded', 'closed_unsuccessful', 'cancelled', 'draft', 'pending_approval']),
            'attachments' => $this->faker->optional(0.4)->randomElements( // 40% chance of having 1-2 attachments
                [
                    ['name' => 'Project Brief.pdf', 'path' => 'tender_attachments/' . $this->faker->uuid . '.pdf'],
                    ['name' => 'Technical Specifications.docx', 'path' => 'tender_attachments/' . $this->faker->uuid . '.docx'],
                    ['name' => 'NDA.pdf', 'path' => 'tender_attachments/' . $this->faker->uuid . '.pdf']
                ],
                $this->faker->numberBetween(1,2)
            ) ?: null,
            'views_count' => $this->faker->numberBetween(0, 5000),
        ];
    }
}
