<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Product;
use Modules\BusinessDirectory\Entities\Company;

class ProductFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Product::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $productName = $this->faker->commerce_product_name;
        $price = $this->faker->randomFloat(2, 5, 500);
        return [
            'company_id' => Company::factory(),
            'name' => $productName,
            // slug will be auto-generated by the HasSlug trait in the Product model
            'description' => $this->faker->paragraphs(3, true),
            'sku' => $this->faker->optional()->bothify('SKU-####??**'), // More complex SKU
            'price' => $price,
            'sale_price' => $this->faker->optional(0.3)->randomFloat(2, ($price * 0.5), ($price * 0.9)), // 30% chance, sale price is 50-90% of original
            'stock_quantity' => $this->faker->numberBetween(0, 200),
            'is_featured' => $this->faker->boolean(10), // 10% chance
            'status' => $this->faker->randomElement(['published', 'draft', 'archived', 'out_of_stock']),
            'images' => $this->faker->optional(0.8)->randomElements( // 80% chance of having 1-3 images
                [
                    $this->faker->imageUrl(640, 480, 'technics', true),
                    $this->faker->imageUrl(640, 480, 'gadgets', true),
                    $this->faker->imageUrl(640, 480, 'fashion', true),
                    $this->faker->imageUrl(640, 480, 'sports', true),
                ],
                $this->faker->numberBetween(1,3)
            ) ?: null,
            'meta_title' => 'Buy ' . $productName . ' Online - Best Deals',
            'meta_description' => 'Get the best deal on ' . $productName . '. High quality, affordable price. ' . $this->faker->sentence,
            'meta_keywords' => strtolower($productName) . ', e-commerce, online shopping, buy ' . $this->faker->word,
        ];
    }
}
