<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Company;
use Modules\BusinessDirectory\Entities\Order;
use Modules\BusinessDirectory\Entities\OrderItem;
use App\Entities\User; // Assuming global User model

class OrderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Order::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'user_id' => User::factory(),
            'company_id' => Company::factory(), // The seller company
            // order_number is auto-generated by the model
            'total_amount' => $this->faker->randomFloat(2, 20, 1000), // Will be recalculated if items are added
            'currency' => $this->faker->randomElement(['USD', 'EUR', 'GBP', 'KES']),
            'status' => $this->faker->randomElement(['pending', 'processing', 'shipped', 'delivered', 'cancelled', 'refunded']),
            'payment_method' => $this->faker->randomElement(['credit_card', 'paypal', 'bank_transfer', 'mpesa']),
            'payment_status' => $this->faker->randomElement(['pending', 'paid', 'failed', 'refunded']),
            'shipping_address' => [
                'name' => $this->faker->name,
                'address_line_1' => $this->faker->streetAddress,
                'city' => $this->faker->city,
                'state' => $this->faker->state,
                'zip_code' => $this->faker->postcode,
                'country' => $this->faker->country,
            ],
            'billing_address' => [ // Often same as shipping, but can differ
                'name' => $this->faker->name,
                'address_line_1' => $this->faker->streetAddress,
                'city' => $this->faker->city,
                'state' => $this->faker->state,
                'zip_code' => $this->faker->postcode,
                'country' => $this->faker->country,
            ],
            'notes' => $this->faker->optional()->sentence,
        ];
    }
}