<?php

namespace Modules\BusinessDirectory\Database\factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\BusinessDirectory\Entities\Company;
use Modules\BusinessDirectory\Entities\CompanyProject;

class CompanyProjectFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = CompanyProject::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $startDate = $this->faker->dateTimeBetween('-1 year', 'now');
        return [
            'company_id' => Company::factory(),
            'name' => $this->faker->bs . ' Project',
            // slug will be auto-generated
            'description' => $this->faker->paragraphs(2, true),
            'start_date' => $startDate,
            'end_date' => $this->faker->optional(0.7)->dateTimeBetween($startDate, '+1 year'), // 70% chance of having an end date
            'budget' => $this->faker->optional()->randomFloat(2, 5000, 200000),
            'currency' => $this->faker->randomElement(['USD', 'EUR', 'GBP', 'KES']),
            'status' => $this->faker->randomElement(['planning', 'in_progress', 'completed', 'on_hold', 'cancelled']),
            'client_company_id' => $this->faker->optional(0.3)->randomElement(Company::pluck('id')->toArray()) ?: null, // 30% chance of having a client company
        ];
    }
}