<?php

return [
    'name' => 'BusinessDirectory',

    'pagination_count' => 12, // Default pagination count for listings
    'auto_approve_companies' => false, // Auto-approve new company listings

    'order_statuses' => [
        'pending' => 'Pending',
        'processing' => 'Processing',
        'shipped' => 'Shipped',
        'delivered' => 'Delivered',
        'completed' => 'Completed',
        'cancelled' => 'Cancelled',
        'refunded' => 'Refunded',
        'payment_failed' => 'Payment Failed',
        'on_hold' => 'On Hold',
    ],

    'payment_statuses' => [
        'pending' => 'Pending',
        'paid' => 'Paid',
        'failed' => 'Failed',
        'refunded' => 'Refunded',
        'partially_paid' => 'Partially Paid',
        'partially_refunded' => 'Partially Refunded',
    ],

    // Social Links
    'social_facebook_url' => null,
    'social_twitter_url' => null,
    'social_linkedin_url' => null,
    'social_instagram_url' => null,

    // Homepage Hero Section
    'homepage_hero_title' => 'Find Local Experts & Services',
    'homepage_hero_subtitle' => 'Your ultimate guide to trusted companies, top products, and valuable service tenders.',
    'homepage_hero_search_placeholder' => 'Search businesses, products, services...',

    // Hero Slider (Example for up to 2 slides, extend as needed)
    'hero_slide_1_image' => null, // Path to image
    'hero_slide_1_title' => 'Discover Top Companies',
    'hero_slide_1_subtitle' => 'Explore industry leaders and innovative businesses.',
    'hero_slide_1_button_text' => 'Browse Companies',
    'hero_slide_1_button_link' => '/companies', // Example link

    'hero_slide_2_image' => null,
    'hero_slide_2_title' => 'Shop Amazing Products',
    'hero_slide_2_subtitle' => 'Find unique items and great deals.',
    'hero_slide_2_button_text' => 'Explore Products',
    'hero_slide_2_button_link' => '/products',

    // Homepage Section Counts
    'homepage_featured_companies_count' => 6,
    'homepage_featured_products_count' => 8,
    'homepage_latest_tenders_count' => 5,
    'homepage_latest_jobs_count' => 5,

    // Default display image paths (relative to public directory)
    'default_logo_path' => 'images/defaults/company_logo.png',
    'default_banner_path' => 'images/defaults/company_banner.png',
    'default_product_image_path' => 'images/defaults/product_image.png',

    // Storage paths for uploads (relative to the 'public' disk's root)
    'storage_paths' => [
        'logos' => 'company-logos',
        'banners' => 'company-banners',
        'product_images' => 'product-images',
        'tender_attachments' => 'tender-attachments',
        'job_attachments' => 'job-attachments',
    ],

    // Add other module-specific configurations here
    'require_reapproval_on_company_edit' => false, // Does editing an approved company require re-approval?
    'auto_approve_reviews' => false, // Auto-approve new company reviews
    'auto_approve_tenders' => false, // Auto-approve new tenders
    'auto_approve_jobs' => false,    // Auto-approve new jobs
    'auto_approve_products' => false, // Auto-approve new products
];
