<?php

namespace Modules\BusinessDirectory\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Str;
// Assuming Company model is in the same namespace
// use Modules\BusinessDirectory\Entities\Company;
// Assuming Bid model is in the same namespace
// use Modules\BusinessDirectory\Entities\Bid;

class Tender extends Model
{
    use HasFactory;

    protected $table = 'bd_tenders';

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'company_id',
        'title',
        'slug',
        'description',
        'requirements',
        'budget_amount',
        'budget_currency',
        'deadline_for_bids',
        'status',
    ];

    protected $casts = [
        'budget_amount' => 'decimal:2',
        'deadline_for_bids' => 'datetime',
    ];

    protected static function newFactory()
    {
        return \Modules\BusinessDirectory\Database\factories\TenderFactory::new();
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function bids(): HasMany
    {
        return $this->hasMany(Bid::class)->orderBy('created_at', 'desc');
    }
}
