<?php

namespace Modules\BusinessDirectory\Entities; // Corrected namespace

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Str;

class CompanyType extends Model
{
    use HasFactory;
    
    protected $table = 'bd_company_types';

    protected $fillable = [
        'name',
        'slug',
        'description',
    ];

    protected static function newFactory()
    {
        return \Modules\BusinessDirectory\Database\factories\CompanyTypeFactory::new();
    }

    protected static function boot() {
        parent::boot();
        static::creating(function ($companyType) {
            $companyType->slug = Str::slug($companyType->name);
        });
    }
}