<?php

namespace Modules\BusinessDirectory\Policies; // Corrected namespace

use App\Models\User; // Assuming your User model is in App\Models
use Modules\BusinessDirectory\Entities\Category;
use Illuminate\Auth\Access\HandlesAuthorization; // Import HandlesAuthorization

class CategoryPolicy
{
    use HandlesAuthorization; // Use the trait

    /**
     * Perform pre-authorization checks.
     *
     * @param  \App\Models\User  $user
     * @param  string  $ability
     * @return bool|null
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->isAdmin()) { // Assuming you have an isAdmin() method on your User model
            return true;
        }
        return null; // Let other policy methods decide
    }

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        // Admins can view all (handled by before).
        // Categories are generally public, so allow viewing the list.
        return true;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Category $category): bool
    {
        // Admins can view (handled by before).
        // Categories are generally public.
        return true;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        // Only admins can create categories (handled by before).
        return false; // Default to false for non-admins
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Category $category): bool
    {
        // Only admins can update categories (handled by before).
        return false; // Default to false for non-admins
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Category $category): bool
    {
        // Only admins can delete categories (handled by before).
        return false; // Default to false for non-admins
    }

    // restore and forceDelete methods are typically admin-only actions
    // and are covered by the before() method. If you need specific logic
    // for non-admins (which is unlikely for these actions on categories),
    // you can implement them here.
}