<?php

namespace App\Policies;

use App\Models\User;
use Modules\BusinessDirectory\Settings\BusinessDirectorySettings;

class BusinessDirectorySettingPolicy
{
    /**
     * Perform pre-authorization checks.
     *
     * @param  \App\Models\User  $user
     * @param  string  $ability
     * @return bool|null
     */
    public function before(User $user, string $ability): bool|null
    {
        if ($user->isAdmin()) { // Assuming you have an isAdmin() method on your User model
            return true;
        }
        return null;
    }

    public function manage_settings(User $user, BusinessDirectorySettings $settings): bool
    {
        // The 'before' method will grant access to admins.
        // For non-admins, this will default to false unless specific logic is added.
        return false;
    }
}