<?php

namespace Modules\BusinessDirectory\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Modules\BusinessDirectory\Events\NewJobApplicationSubmitted;
// use Modules\BusinessDirectory\Notifications\NotifyCompanyOfNewApplication; // Example Notification

class SendNewJobApplicationNotification // implements ShouldQueue // Uncomment if you want this listener to be queued
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  NewJobApplicationSubmitted  $event
     * @return void
     */
    public function handle(NewJobApplicationSubmitted $event)
    {
        Log::info("New job application submitted for job ID: {$event->application->job_id} by user ID: {$event->application->user_id}");

        // Example: Notify the company owner
        // $companyOwner = $event->application->job->company->owner; // Assuming these relationships exist
        // if ($companyOwner) {
        //     $companyOwner->notify(new NotifyCompanyOfNewApplication($event->application));
        // }
    }
}