<?php

namespace Modules\BusinessDirectory\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Modules\BusinessDirectory\Events\NewTenderPosted;
// use App\Models\User; // If you need to find users to notify
// use Modules\BusinessDirectory\Notifications\NewTenderAvailableNotification; // Example

class NotifyUsersOfNewTender // implements ShouldQueue
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(NewTenderPosted $event): void
    {
        Log::info("New tender posted: {$event->tender->title} (ID: {$event->tender->id}) by company ID: {$event->tender->company_id}");

        // Example: Notify users who might be interested (e.g., followers of the company, users in relevant categories)
        // $interestedUsers = User::where(...)->get(); // Your logic to find interested users
        // foreach ($interestedUsers as $user) {
        //     $user->notify(new NewTenderAvailableNotification($event->tender));
        // }
    }
}