<?php

namespace Modules\BusinessDirectory\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Modules\BusinessDirectory\Events\BidWithdrawn;
// use Modules\BusinessDirectory\Notifications\NotifyTenderOwnerOfBidWithdrawalNotification; // Example

class NotifyTenderOwnerOfBidWithdrawal // implements ShouldQueue
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(BidWithdrawn $event): void
    {
        Log::info("Bid ID: {$event->bid->id} was withdrawn from tender ID: {$event->bid->tender_id}. Notifying owner.");

        // Example: Notify the tender owner
        // $tenderOwner = $event->bid->tender->company->owner; // Assuming relationships
        // if ($tenderOwner) {
        //     $tenderOwner->notify(new NotifyTenderOwnerOfBidWithdrawalNotification($event->bid));
        // }
    }
}