<?php

namespace Modules\BusinessDirectory\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Modules\BusinessDirectory\Events\TenderAwardedToAnotherBidder;
// use Modules\BusinessDirectory\Notifications\TenderAwardedNotification; // Example

class NotifyLosingBiddersOfTenderAward // implements ShouldQueue
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(TenderAwardedToAnotherBidder $event): void
    {
        Log::info("Tender ID: {$event->tender->id} awarded to Bid ID: {$event->winningBid->id}. Notifying other bidders.");

        $losingBids = $event->tender->bids()
            ->where('id', '!=', $event->winningBid->id)
            ->where('status', '!=', 'withdrawn') // Don't notify already withdrawn bids
            ->with('bidderUser', 'bidderCompany.owner') // Eager load for notification target
            ->get();

        // foreach ($losingBids as $losingBid) {
        //     $notifiable = $losingBid->bidderUser ?? ($losingBid->bidderCompany ? $losingBid->bidderCompany->owner : null);
        //     if ($notifiable) {
        //         $notifiable->notify(new TenderAwardedNotification($event->tender, $losingBid, false)); // false indicates they didn't win
        //     }
        // }
    }
}