<?php

namespace Modules\BusinessDirectory\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Modules\BusinessDirectory\Events\BidStatusUpdated;
// use Modules\BusinessDirectory\Notifications\YourBidStatusChangedNotification; // Example

class NotifyBidderOfStatusChange // implements ShouldQueue
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(BidStatusUpdated $event): void
    {
        Log::info("Bid ID: {$event->bid->id} status updated to: {$event->newStatus}. Notifying bidder.");

        // Example: Notify the bidder
        // $bidder = $event->bid->bidderUser ?? ($event->bid->bidderCompany ? $event->bid->bidderCompany->owner : null);
        // if ($bidder) {
        //     $bidder->notify(new YourBidStatusChangedNotification($event->bid, $event->newStatus));
        // }
    }
}