<?php

namespace Modules\BusinessDirectory\Listeners;

use App\Models\User; // Assuming your User model path
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Modules\BusinessDirectory\Events\NewReviewSubmittedForApproval;
// use Modules\BusinessDirectory\Notifications\AdminNewReviewNotification; // Example Notification

class NotifyAdminOfNewReview // implements ShouldQueue
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(NewReviewSubmittedForApproval $event): void
    {
        Log::info("New review submitted for company ID: {$event->review->company_id} by user ID: {$event->review->user_id}. Review ID: {$event->review->id}");

        // Example: Notify administrators
        // $admins = User::where('is_admin', true)->get(); // Or however you get admins
        // foreach ($admins as $admin) {
        //     $admin->notify(new AdminNewReviewNotification($event->review));
        // }
    }
}