<?php

namespace Modules\BusinessDirectory\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class StoreCompanyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     * Authorization is handled by the CompanyPolicy in the controller.
     */
    public function authorize(): bool
    {
        // The policy check is done in the controller's store method
        // $this->authorize('create', Company::class);
        return Auth::check(); // Basic check that user is logged in
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255', Rule::unique('bd_companies', 'name')],
            'company_type_id' => 'required|exists:bd_company_types,id',
            'description' => 'required|string|max:10000',
            'email' => ['required', 'string', 'email', 'max:255', Rule::unique('bd_companies', 'email')],
            'phone_number' => 'nullable|string|max:30',
            'website_url' => 'nullable|url|max:255',
            'whatsapp_number' => 'nullable|string|max:30',
            'address_line_1' => 'nullable|string|max:255',
            'address_line_2' => 'nullable|string|max:255',
            'city' => 'nullable|string|max:100',
            'state_province' => 'nullable|string|max:100',
            'postal_code' => 'nullable|string|max:20',
            'country_code' => 'nullable|string|max:2',
            'latitude' => 'nullable|numeric|between:-90,90',
            'longitude' => 'nullable|numeric|between:-180,180',
            'logo_path' => ['nullable', 'image', 'mimes:jpg,jpeg,png,gif,svg,webp', 'max:2048'],
            'banner_image_path' => ['nullable', 'image', 'mimes:jpg,jpeg,png,webp', 'max:5120'],
            'is_ecommerce' => 'boolean',
            'established_date' => 'nullable|date',
            'employee_count' => 'nullable|string|max:50',
            'facebook_url' => 'nullable|url|max:255',
            'twitter_url' => 'nullable|url|max:255',
            'linkedin_url' => 'nullable|url|max:255',
            'instagram_url' => 'nullable|url|max:255',
            'meta_title' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string|max:1000',
            'meta_keywords' => 'nullable|string|max:255', // Comma-separated keywords
        ];
    }

    /**
     * Prepare the data for validation.
     */
    protected function prepareForValidation(): void
    {
        // Ensure is_ecommerce is a boolean
        $this->merge([
            'is_ecommerce' => $this->has('is_ecommerce'),
        ]);
    }
}