<?php

namespace Modules\BusinessDirectory\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Modules\BusinessDirectory\Entities\Order;

class UpdateOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        // Policy check is done in the controller, but basic admin check here is fine.
        return Auth::check() && Auth::user()->isAdmin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        $orderStatuses = method_exists(Order::class, 'getStatuses') ?
                         array_keys(Order::getStatuses()) :
                         array_keys(config('businessdirectory.order_statuses', []));

        $paymentStatuses = method_exists(Order::class, 'getPaymentStatuses') ?
                           array_keys(Order::getPaymentStatuses()) :
                           array_keys(config('businessdirectory.payment_statuses', []));

        return [
            'status' => ['sometimes', 'required', 'string', Rule::in($orderStatuses)],
            'payment_status' => ['sometimes', 'required', 'string', Rule::in($paymentStatuses)],
            // Add other updatable fields like tracking_number, admin_notes, etc.
            // 'tracking_number' => 'nullable|string|max:255',
            // 'admin_notes' => 'nullable|string|max:1000',
        ];
    }
}
