<?php

namespace Modules\BusinessDirectory\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class UpdateCompanyTypeRequest extends FormRequest
{
    public function authorize(): bool
    {
        return Auth::check() && Auth::user()->isAdmin(); // Or your specific admin check
    }

    public function rules(): array
    {
        $companyTypeId = $this->route('company_type')->id; // Assuming route model binding 'company_type'

        return [
            'name' => ['required', 'string', 'max:255', Rule::unique('bd_company_types', 'name')->ignore($companyTypeId)],
            'description' => 'nullable|string|max:1000',
            'icon' => ['nullable', 'image', 'mimes:jpg,jpeg,png,svg,webp', 'max:1024'],
            'meta_title' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string|max:1000',
            'meta_keywords' => 'nullable|string|max:255',
        ];
    }

    /**
     * Prepare the data for validation.
     *
     * @return void
     */
    protected function prepareForValidation()
    {
        // If you need to ensure the slug is updated when the name changes,
        // you might handle that in the controller or model events.
    }
}