<?php

namespace Modules\BusinessDirectory\Http\Controllers\Frontend;

use Illuminate\Contracts\Support\Renderable;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\BusinessDirectory\Entities\Order;
use Illuminate\Support\Facades\Auth;

class OrderController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function myOrders(Request $request)
    {
        $user = auth()->user();
        $query = Order::where('user_id', $user->id)->with('company', 'items')->latest();

        // Add filtering/searching
        if ($request->filled('search')) {
            $searchTerm = $request->input('search');
            $query->where(function($q) use ($searchTerm) {
                $q->where('order_number', 'like', "%{$searchTerm}%")
                  ->orWhereHas('company', fn($cq) => $cq->where('name', 'like', "%{$searchTerm}%"));
            });
        }
        // Example status filter
        if ($request->filled('status')) {
            $query->where('status', $request->input('status'));
        }

        $orders = $query->paginate(10);

        return view('businessdirectory::frontend.orders.my_index', compact('orders'));
    }

    /**
     * Display the specified order.
     *
     * @param  Order $order
     * @return \Illuminate\Contracts\View\View
     */
    public function showMyOrder(Order $order)
    {
        $this->authorize('view', $order); // Make sure user owns this order
        
        // Eager load relationships for the order details view
        $order->load(['items.product', 'company', 'user']); // Load items with their products, the company, and the user (customer)

        return view('businessdirectory::frontend.orders.show_my_order', compact('order')); // You'll need to create this view
    }
}