<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Notifications\DatabaseNotification; // Import DatabaseNotification

class NotificationController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $notifications = $user->notifications()->paginate(15);
        // Optionally mark them as read upon viewing the page, or provide buttons
        // $user->unreadNotifications->markAsRead();
        return view('frontend.notifications.index', compact('notifications'));
    }

    public function markAsRead(Request $request, $notificationId)
    {
        $user = Auth::user();
        $notification = $user->notifications()->findOrFail($notificationId);
        $notification->markAsRead();
        return back()->with('success', 'Notification marked as read.');
    }

    public function markAllAsRead(Request $request)
    {
        $user = Auth::user();
        $user->unreadNotifications->markAsRead();
        return back()->with('success', 'All unread notifications marked as read.');
    }

    /**
     * Mark a specific notification as read and redirect to its intended link.
     *
     * @param  \Illuminate\Http\Request  $request (can be removed if not used)
     * @param  \Illuminate\Notifications\DatabaseNotification  $notification
     * @return \Illuminate\Http\RedirectResponse
     */
    public function readAndRedirect(Request $request, DatabaseNotification $notification)
    {
        // Ensure the notification belongs to the authenticated user
        if (Auth::id() !== $notification->notifiable_id) {
            abort(403, 'This action is unauthorized.');
        }

        $notification->markAsRead();

        // Redirect to the link stored in the notification data, or a default if not present
        $redirectUrl = $notification->data['link'] ?? route('frontend.dashboard'); // Default to dashboard
        return redirect($redirectUrl);
    }
}
