<?php

namespace Modules\BusinessDirectory\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\BusinessDirectory\Entities\Company;
use Modules\BusinessDirectory\Entities\Tender;
use Modules\BusinessDirectory\Entities\Job;

class BusinessDirectoryController extends Controller
{
    /**
     * Display the main landing page for the Business Directory module.
     * This page could show featured companies, recent tenders, jobs, etc.
     */
    public function index()
    {
        $featuredCompanies = Company::where('is_featured', true)
            ->where('status', 'approved')
            ->orderBy('name')
            ->take(6)
            ->get();

        $recentOpenTenders = Tender::where('status', 'open')
            ->latest()
            ->take(5)
            ->get();

        $recentOpenJobs = Job::where('status', 'open')
            ->latest()
            ->take(5)
            ->get();

        return view('businessdirectory::index', compact(
            'featuredCompanies',
            'recentOpenTenders',
            'recentOpenJobs'
        ));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // If this controller is not managing a specific resource, this method might be unused.
        return view('businessdirectory::create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // If this controller is not managing a specific resource, this method might be unused.
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        // If this controller is not managing a specific resource, this method might be unused.
        // What resource does $id refer to here?
        return view('businessdirectory::show');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        // If this controller is not managing a specific resource, this method might be unused.
        return view('businessdirectory::edit');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        // If this controller is not managing a specific resource, this method might be unused.
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        // If this controller is not managing a specific resource, this method might be unused.
    }
}
