<?php

namespace Modules\BusinessDirectory\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\BusinessDirectory\Entities\Company;
use Modules\BusinessDirectory\Entities\Tender;
use Modules\BusinessDirectory\Entities\Category;
use Modules\BusinessDirectory\Entities\CompanyType;
use Modules\BusinessDirectory\Entities\Review;
use Modules\BusinessDirectory\Entities\Product;

class DashboardController extends Controller
{
    /**
     * Display the admin dashboard for the BusinessDirectory module.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $companyCount = Company::count();
        $pendingCompanyCount = Company::where('status', 'pending')->count();
        $activeTenderCount = Tender::where('status', 'open')->count(); // Example: only open tenders
        $productCount = Product::count();
        $categoryCount = Category::count();
        $companyTypeCount = CompanyType::count();
        $pendingReviewCount = Review::where('is_approved', false)->count();

        return view('businessdirectory::admin.dashboard', compact(
            'companyCount',
            'pendingCompanyCount',
            'activeTenderCount',
            'productCount',
            'categoryCount',
            'companyTypeCount',
            'pendingReviewCount'
        ));
    }
}
