<?php

namespace Modules\BusinessDirectory\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Modules\BusinessDirectory\Entities\Tender;
use Modules\BusinessDirectory\Entities\Bid;

class TenderAwardedToAnotherBidder
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Tender $tender;
    public Bid $winningBid;

    /**
     * Create a new event instance.
     *
     * @param Tender $tender
     * @param Bid $winningBid The bid that was accepted.
     */
    public function __construct(Tender $tender, Bid $winningBid)
    {
        $this->tender = $tender;
        $this->winningBid = $winningBid;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return array
     */
    public function broadcastOn(): array
    {
        return [];
    }
}