<?php

namespace Modules\BusinessDirectory\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes; // Keep if bd_company_types has deleted_at
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class CompanyType extends Model
{
    use HasFactory, HasSlug;
    // use SoftDeletes; // Uncomment this and the SoftDeletes import if your 'bd_company_types' table has a 'deleted_at' column.
    protected $table = 'bd_company_types';

    protected $fillable = [
        'name',
        'slug',
        'description',
        'icon',
    ];

    /**
     * Get the options for generating the slug.
     */
    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('name')
            ->saveSlugsTo('slug');
    }

    // If you decide to add soft deletes to company_types table, uncomment this.
    // Also, ensure your migration includes `$table->softDeletes();`
    // protected $dates = ['deleted_at']; 


    protected static function newFactory()
    {
        return \Modules\BusinessDirectory\Database\factories\CompanyTypeFactory::new();
    }

    public function companies(): HasMany {
        return $this->hasMany(Company::class);
    }
}
