<?php

namespace Modules\BusinessDirectory\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\BusinessDirectory\Entities\Product; // Explicit import for Product

class CartItem extends Model
{
    use HasFactory;

    protected $table = 'bd_cart_items';

    protected $fillable = [
        'cart_id',
        'product_id',
        'quantity',
        'price_at_addition', // Price of the product when it was added to cart
    ];

    protected $casts = [
        'quantity' => 'integer',
        'price_at_addition' => 'decimal:2',
    ];

    /**
     * The cart this item belongs to.
     */
    public function cart(): BelongsTo
    {
        return $this->belongsTo(Cart::class);
    }

    /**
     * The product associated with this cart item.
     */
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    /**
     * Calculate the subtotal for this cart item.
     */
    public function getSubtotalAttribute()
    {
        return $this->quantity * $this->price_at_addition;
    }

    protected static function newFactory() {
        return \Modules\BusinessDirectory\Database\factories\CartItemFactory::new();
    }
}