import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import fs from 'fs';
import path from 'path';

// Determine the host for the dev server.
// When using ngrok, Vite needs to know the ngrok host for HMR.
// You might need to set this dynamically or ensure your APP_URL is correctly picked up.
// For simplicity, if your APP_URL is set to the ngrok URL, Vite might pick it up.
// Otherwise, you might need to pass it or use 'localhost' if ngrok tunnels to localhost.
const appUrl = process.env.APP_URL || 'http://localhost:8000';
const host = new URL(appUrl).hostname;

export default defineConfig({
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.js'],
            refresh: true,
        }),
    ],
    server: {
        host: '0.0.0.0', // Listen on all network interfaces, useful for ngrok
        https: {
            key: fs.readFileSync(path.resolve(__dirname, 'certs/localhost-key.pem')), // Adjust if your key file has a different name
            cert: fs.readFileSync(path.resolve(__dirname, 'certs/localhost.pem')),   // Adjust if your cert file has a different name
        },
        hmr: {
            host: host, // Use the ngrok hostname for HMR
        },
    }
});
