<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/aiplatform/v1/feature_registry_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AIPlatform\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AIPlatform\V1\BatchCreateFeaturesRequest;
use Google\Cloud\AIPlatform\V1\CreateFeatureGroupRequest;
use Google\Cloud\AIPlatform\V1\CreateFeatureRequest;
use Google\Cloud\AIPlatform\V1\DeleteFeatureGroupRequest;
use Google\Cloud\AIPlatform\V1\DeleteFeatureRequest;
use Google\Cloud\AIPlatform\V1\Feature;
use Google\Cloud\AIPlatform\V1\FeatureGroup;
use Google\Cloud\AIPlatform\V1\GetFeatureGroupRequest;
use Google\Cloud\AIPlatform\V1\GetFeatureRequest;
use Google\Cloud\AIPlatform\V1\ListFeatureGroupsRequest;
use Google\Cloud\AIPlatform\V1\ListFeaturesRequest;
use Google\Cloud\AIPlatform\V1\UpdateFeatureGroupRequest;
use Google\Cloud\AIPlatform\V1\UpdateFeatureRequest;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: The service that handles CRUD and List for resources for
 * FeatureRegistry.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> batchCreateFeaturesAsync(BatchCreateFeaturesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createFeatureAsync(CreateFeatureRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> createFeatureGroupAsync(CreateFeatureGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteFeatureAsync(DeleteFeatureRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> deleteFeatureGroupAsync(DeleteFeatureGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Feature> getFeatureAsync(GetFeatureRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<FeatureGroup> getFeatureGroupAsync(GetFeatureGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFeatureGroupsAsync(ListFeatureGroupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFeaturesAsync(ListFeaturesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateFeatureAsync(UpdateFeatureRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateFeatureGroupAsync(UpdateFeatureGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Policy> setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<TestIamPermissionsResponse> testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 */
final class FeatureRegistryServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.aiplatform.v1.FeatureRegistryService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'aiplatform.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'aiplatform.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/feature_registry_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/feature_registry_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/feature_registry_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/feature_registry_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a entity_type
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     *
     * @return string The formatted entity_type resource.
     */
    public static function entityTypeName(
        string $project,
        string $location,
        string $featurestore,
        string $entityType
    ): string {
        return self::getPathTemplate('entityType')->render([
            'project' => $project,
            'location' => $location,
            'featurestore' => $featurestore,
            'entity_type' => $entityType,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a feature
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     * @param string $feature
     *
     * @return string The formatted feature resource.
     */
    public static function featureName(
        string $project,
        string $location,
        string $featurestore,
        string $entityType,
        string $feature
    ): string {
        return self::getPathTemplate('feature')->render([
            'project' => $project,
            'location' => $location,
            'featurestore' => $featurestore,
            'entity_type' => $entityType,
            'feature' => $feature,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * feature_group resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featureGroup
     *
     * @return string The formatted feature_group resource.
     */
    public static function featureGroupName(string $project, string $location, string $featureGroup): string
    {
        return self::getPathTemplate('featureGroup')->render([
            'project' => $project,
            'location' => $location,
            'feature_group' => $featureGroup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_feature_group_feature resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featureGroup
     * @param string $feature
     *
     * @return string The formatted project_location_feature_group_feature resource.
     */
    public static function projectLocationFeatureGroupFeatureName(
        string $project,
        string $location,
        string $featureGroup,
        string $feature
    ): string {
        return self::getPathTemplate('projectLocationFeatureGroupFeature')->render([
            'project' => $project,
            'location' => $location,
            'feature_group' => $featureGroup,
            'feature' => $feature,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_featurestore_entity_type_feature resource.
     *
     * @param string $project
     * @param string $location
     * @param string $featurestore
     * @param string $entityType
     * @param string $feature
     *
     * @return string The formatted project_location_featurestore_entity_type_feature resource.
     */
    public static function projectLocationFeaturestoreEntityTypeFeatureName(
        string $project,
        string $location,
        string $featurestore,
        string $entityType,
        string $feature
    ): string {
        return self::getPathTemplate('projectLocationFeaturestoreEntityTypeFeature')->render([
            'project' => $project,
            'location' => $location,
            'featurestore' => $featurestore,
            'entity_type' => $entityType,
            'feature' => $feature,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - entityType: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}
     * - feature: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}
     * - featureGroup: projects/{project}/locations/{location}/featureGroups/{feature_group}
     * - location: projects/{project}/locations/{location}
     * - projectLocationFeatureGroupFeature: projects/{project}/locations/{location}/featureGroups/{feature_group}/features/{feature}
     * - projectLocationFeaturestoreEntityTypeFeature: projects/{project}/locations/{location}/featurestores/{featurestore}/entityTypes/{entity_type}/features/{feature}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'aiplatform.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates a batch of Features in a given FeatureGroup.
     *
     * The async variant is
     * {@see FeatureRegistryServiceClient::batchCreateFeaturesAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/batch_create_features.php
     *
     * @param BatchCreateFeaturesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchCreateFeatures(BatchCreateFeaturesRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('BatchCreateFeatures', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Feature in a given FeatureGroup.
     *
     * The async variant is {@see FeatureRegistryServiceClient::createFeatureAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/create_feature.php
     *
     * @param CreateFeatureRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFeature(CreateFeatureRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateFeature', $request, $callOptions)->wait();
    }

    /**
     * Creates a new FeatureGroup in a given project and location.
     *
     * The async variant is
     * {@see FeatureRegistryServiceClient::createFeatureGroupAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/create_feature_group.php
     *
     * @param CreateFeatureGroupRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFeatureGroup(CreateFeatureGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateFeatureGroup', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single Feature.
     *
     * The async variant is {@see FeatureRegistryServiceClient::deleteFeatureAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/delete_feature.php
     *
     * @param DeleteFeatureRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteFeature(DeleteFeatureRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteFeature', $request, $callOptions)->wait();
    }

    /**
     * Deletes a single FeatureGroup.
     *
     * The async variant is
     * {@see FeatureRegistryServiceClient::deleteFeatureGroupAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/delete_feature_group.php
     *
     * @param DeleteFeatureGroupRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteFeatureGroup(DeleteFeatureGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteFeatureGroup', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Feature.
     *
     * The async variant is {@see FeatureRegistryServiceClient::getFeatureAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/get_feature.php
     *
     * @param GetFeatureRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Feature
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFeature(GetFeatureRequest $request, array $callOptions = []): Feature
    {
        return $this->startApiCall('GetFeature', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single FeatureGroup.
     *
     * The async variant is {@see FeatureRegistryServiceClient::getFeatureGroupAsync()}
     * .
     *
     * @example samples/V1/FeatureRegistryServiceClient/get_feature_group.php
     *
     * @param GetFeatureGroupRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return FeatureGroup
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFeatureGroup(GetFeatureGroupRequest $request, array $callOptions = []): FeatureGroup
    {
        return $this->startApiCall('GetFeatureGroup', $request, $callOptions)->wait();
    }

    /**
     * Lists FeatureGroups in a given project and location.
     *
     * The async variant is
     * {@see FeatureRegistryServiceClient::listFeatureGroupsAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/list_feature_groups.php
     *
     * @param ListFeatureGroupsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFeatureGroups(ListFeatureGroupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFeatureGroups', $request, $callOptions);
    }

    /**
     * Lists Features in a given FeatureGroup.
     *
     * The async variant is {@see FeatureRegistryServiceClient::listFeaturesAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/list_features.php
     *
     * @param ListFeaturesRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFeatures(ListFeaturesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFeatures', $request, $callOptions);
    }

    /**
     * Updates the parameters of a single Feature.
     *
     * The async variant is {@see FeatureRegistryServiceClient::updateFeatureAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/update_feature.php
     *
     * @param UpdateFeatureRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFeature(UpdateFeatureRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateFeature', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a single FeatureGroup.
     *
     * The async variant is
     * {@see FeatureRegistryServiceClient::updateFeatureGroupAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/update_feature_group.php
     *
     * @param UpdateFeatureGroupRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFeatureGroup(UpdateFeatureGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateFeatureGroup', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see FeatureRegistryServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see FeatureRegistryServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * The async variant is {@see FeatureRegistryServiceClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * The async variant is {@see FeatureRegistryServiceClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * The async variant is
     * {@see FeatureRegistryServiceClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/FeatureRegistryServiceClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(
        TestIamPermissionsRequest $request,
        array $callOptions = []
    ): TestIamPermissionsResponse {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }
}
