import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';
import typography from '@tailwindcss/typography';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './vendor/laravel/jetstream/**/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
        // Add paths for your LandingPage module themes
        './Modules/LandingPage/resources/views/themes/job_board/**/*.blade.php',
        './Modules/LandingPage/resources/views/themes/ai_website_maker/**/*.blade.php',
        './Modules/LandingPage/View/Components/**/*.php', // If you have components with classes
        // Add paths for other modules that use Tailwind classes
        './Modules/BusinessDirectory/resources/views/**/*.blade.php',
        './Modules/WebPilotAI/resources/views/**/*.blade.php',
    ],
    darkMode: 'class', // Add this line

    theme: {
        extend: {
            fontFamily: {
                sans: ['Inter', ...defaultTheme.fontFamily.sans],
                lexend: ['Lexend', 'sans-serif'],
            },
            colors: {
                primary: {
                  50: 'var(--clr-primary-50)',
                  100: 'var(--clr-primary-100)',
                  200: 'var(--clr-primary-200)',
                  300: 'var(--clr-primary-300)',
                  400: 'var(--clr-primary-400)',
                  500: 'var(--clr-primary-500)',
                  600: 'var(--clr-primary-600)',
                  700: 'var(--clr-primary-700)',
                  800: 'var(--clr-primary-800)',
                  900: 'var(--clr-primary-900)',
                  950: 'var(--clr-primary-950)',
                }
            },
        },
    },

    plugins: [forms, typography],
};
