

<?php $__env->startSection('title', 'Application Settings'); ?>
<?php $__env->startSection('header_title', 'Application Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6" x-data="{ 
    activeMainTab: '<?php echo e($activeMainTab); ?>', 
    activeSubTab: '<?php echo e($activeMainTab === 'application' ? ($activeSubTab ?? ($applicationSettingNavItems->isNotEmpty() ? $applicationSettingNavItems->keys()->first() : '')) : ''); ?>' 
}">
    <?php if(session('success')): ?>
        <div class="p-4 text-sm text-green-700 bg-green-100 rounded-lg dark:bg-green-900 dark:text-green-300" role="alert">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="p-4 text-sm text-red-700 bg-red-100 rounded-lg dark:bg-red-900 dark:text-red-300" role="alert">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data" class="space-y-12">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <!-- Main Tab Navigation -->
        <div class="mb-6 border-b border-gray-200 dark:border-gray-700">
            <nav class="-mb-px flex space-x-4 sm:space-x-8" aria-label="Tabs">
                <?php $__currentLoopData = $mainNavItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tabKey => $tabName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(request()->url()); ?>?tab=<?php echo e($tabKey); ?><?php echo e(($tabKey === 'application' && $applicationSettingNavItems->isNotEmpty()) ? '&sub_tab=' . $applicationSettingNavItems->keys()->first() : ''); ?>"
                       @click.prevent="
                           let newMainTab = '<?php echo e($tabKey); ?>';
                           let newSubTabForUrl = '';
                           activeMainTab = newMainTab;
                           if (newMainTab === 'application') {
                               <?php if($applicationSettingNavItems->isNotEmpty()): ?>
                                   // If current activeSubTab is valid for application, keep it, else default to first
                                   let appSubTabs = <?php echo e(json_encode($applicationSettingNavItems->keys())); ?>;
                                   if (appSubTabs.includes(activeSubTab)) {
                                       newSubTabForUrl = activeSubTab;
                                   } else {
                                       newSubTabForUrl = '<?php echo e($applicationSettingNavItems->keys()->first()); ?>';
                                   }
                                   activeSubTab = newSubTabForUrl;
                                   window.history.pushState({}, '', `?tab=${newMainTab}&sub_tab=${activeSubTab}`);
                               <?php else: ?>
                                   activeSubTab = '';
                                   window.history.pushState({}, '', `?tab=${newMainTab}`);
                               <?php endif; ?>
                           } else {
                               activeSubTab = '';
                               window.history.pushState({}, '', `?tab=${newMainTab}`);
                           }
                       "
                       :class="{
                           'border-blue-500 text-blue-600 dark:border-blue-400 dark:text-blue-300': activeMainTab === '<?php echo e($tabKey); ?>',
                           'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-200 dark:hover:border-gray-600': activeMainTab !== '<?php echo e($tabKey); ?>'
                       }"
                       class="whitespace-nowrap py-3 px-1 border-b-2 font-medium text-sm transition-colors duration-150 ease-in-out">
                        <?php echo e($tabName); ?>

                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </nav>
        </div>

        <!-- Application Settings Tab Content -->
        <div x-show="activeMainTab === 'application'" class="space-y-10">
            <?php if($applicationSettingNavItems->isNotEmpty()): ?>
                <!-- Sub Tab Navigation for Application Settings -->
                <div class="mb-6 border-b border-gray-200 dark:border-gray-600">
                    <nav class="-mb-px flex space-x-4 sm:space-x-6 overflow-x-auto pb-px" aria-label="Application Setting Groups">
                        <?php $__currentLoopData = $applicationSettingNavItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subTabKey => $subTabName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(request()->url()); ?>?tab=application&sub_tab=<?php echo e($subTabKey); ?>"
                               @click.prevent="activeSubTab = '<?php echo e($subTabKey); ?>'; window.history.pushState({}, '', '?tab=application&sub_tab=<?php echo e($subTabKey); ?>')"
                               :class="{
                                   'border-purple-500 text-purple-600 dark:border-purple-400 dark:text-purple-300': activeSubTab === '<?php echo e($subTabKey); ?>',
                                   'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-200 dark:hover:border-gray-500': activeSubTab !== '<?php echo e($subTabKey); ?>'
                               }"
                               class="whitespace-nowrap py-2.5 px-1 border-b-2 font-medium text-xs sm:text-sm transition-colors duration-150 ease-in-out">
                                <?php echo e($subTabName); ?>

                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </nav>
                </div>

                
                <?php if(Auth::user()->isSuperAdmin() && $applicationSettingNavItems->has('permissions')): ?>
                <div x-show="activeSubTab === 'permissions'" class="space-y-10">
                    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl overflow-hidden">
                        <div class="px-6 py-5 border-b border-gray-200 dark:border-gray-700">
                            <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-gray-100">
                                Admin Role Permissions for Setting Groups
                            </h3>
                            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                                Manage 'Admin' role access to all setting groups (Application & Modules).
                            </p>
                        </div>
                        <div class="px-6 py-6">
                            <?php if(empty($adminSettingPermissions)): ?>
                                <p class="text-center text-gray-500 dark:text-gray-400 py-4">No setting groups found to manage permissions for.</p>
                            <?php else: ?>
                                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-x-6 gap-y-8">
                                    <?php $__currentLoopData = $adminSettingPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $originalGroupName => $permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <fieldset class="p-4 border border-gray-300 dark:border-gray-700 rounded-lg">
                                        <legend class="text-base font-medium text-gray-900 dark:text-gray-100 px-2 whitespace-normal break-words">
                                            <?php echo e($originalGroupName); ?>

                                        </legend>
                                        <div class="mt-3 space-y-3">
                                            <div class="flex items-start">
                                                <div class="flex items-center h-5">
                                                    <input id="perm_view_<?php echo e(Str::slug($originalGroupName)); ?>" name="setting_group_permissions[<?php echo e($originalGroupName); ?>][can_view]" type="checkbox" value="1"
                                                           <?php echo e($permissions['can_view'] ? 'checked' : ''); ?>

                                                           class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300 dark:border-gray-600 rounded dark:bg-gray-700">
                                                </div>
                                                <div class="ml-3 text-sm">
                                                    <label for="perm_view_<?php echo e(Str::slug($originalGroupName)); ?>" class="font-medium text-gray-700 dark:text-gray-300">Can View</label>
                                                </div>
                                            </div>
                                            <div class="flex items-start">
                                                <div class="flex items-center h-5">
                                                    <input id="perm_edit_<?php echo e(Str::slug($originalGroupName)); ?>" name="setting_group_permissions[<?php echo e($originalGroupName); ?>][can_edit]" type="checkbox" value="1"
                                                           <?php echo e($permissions['can_edit'] ? 'checked' : ''); ?>

                                                           class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300 dark:border-gray-600 rounded dark:bg-gray-700">
                                                </div>
                                                <div class="ml-3 text-sm">
                                                    <label for="perm_edit_<?php echo e(Str::slug($originalGroupName)); ?>" class="font-medium text-gray-700 dark:text-gray-300">Can Edit</label>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                
                <?php $__currentLoopData = $applicationSettings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $settingsGroupedBySubGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div x-show="activeSubTab === '<?php echo e(Str::slug($groupName)); ?>'" class="space-y-6"> 
                        <?php echo $__env->make('admin.settings.partials.settings-group-card', [
                            'groupDisplayName' => $groupName,
                            'originalGroupName' => $groupName,
                            'settingsGroupedBySubGroup' => $settingsGroupedBySubGroup, // Pass the sub-grouped settings
                            'groupDescription' => $groupDescriptions[$groupName] ?? 'Manage ' . strtolower($groupName) . ' settings.',
                            'canEditGroup' => Auth::user()->isSuperAdmin() || (Auth::user()->hasRole('admin') && \App\Models\SettingGroupPermission::where('role_name', 'admin')->where('setting_group_name', $groupName)->where('can_edit', true)->exists())
                        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                        
                        <?php if(Str::slug($groupName) === 'mail-settings'): ?>
                            <?php
                                $canViewMailSettings = Auth::user()->isSuperAdmin() || (Auth::user()->hasRole('admin') && \App\Models\SettingGroupPermission::where('role_name', 'admin')->where('setting_group_name', 'Mail Settings')->where('can_view', true)->exists());
                            ?>
                            <?php if($canViewMailSettings): ?>
                            <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl overflow-hidden">
                                <div class="px-6 py-5 border-b border-gray-200 dark:border-gray-700">
                                    <h3 class="text-lg leading-6 font-medium text-gray-900 dark:text-gray-100">
                                        Test Mail Configuration
                                    </h3>
                                </div>
                                <div class="px-6 py-6">
                                    <p class="text-sm text-gray-600 dark:text-gray-400 mb-5">
                                        Send a test email to your logged-in email address (<span class="font-medium"><?php echo e(Auth::user()->email); ?></span>) to verify mail settings.
                                    </p>
                                    <div class="flex items-center">
                                        <button type="button" id="sendTestMailBtn"
                                                class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 dark:bg-green-500 dark:hover:bg-green-600 border border-transparent rounded-lg font-semibold text-xs text-white uppercase tracking-widest focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                                            Send Test Email
                                        </button>
                                        <div id="testMailStatus" class="ml-4 text-sm"></div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php elseif(Auth::user()->isSuperAdmin() && empty($adminSettingPermissions) && $applicationSettings->isEmpty()): ?>
                <p class="text-center text-gray-500 dark:text-gray-400 py-8">No application settings available or you do not have permission to view them.</p>
            <?php else: ?>
                <p class="text-center text-gray-500 dark:text-gray-400 py-8">No application settings groups are available for you to view or manage.</p>
            <?php endif; ?>
        </div>

        <!-- Module Settings Tabs Content -->
        <?php $__currentLoopData = $moduleSettings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $moduleDisplayName => $groupsInModule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div x-show="activeMainTab === '<?php echo e(Str::slug($moduleDisplayName)); ?>'" class="space-y-10">
                <?php if($groupsInModule->isEmpty()): ?>
                    <p class="text-center text-gray-500 dark:text-gray-400 py-8">No setting groups available for the <?php echo e($moduleDisplayName); ?> module or you do not have permission to view them.</p>
                <?php else: ?>
                    <?php $__currentLoopData = $groupsInModule; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupNameInModule => $settingsInGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            // Reconstruct the original group name for permission checking
                            // This assumes module keys are simple strings without '::'
                            // If module keys can contain '::', this logic needs adjustment or a direct mapping from controller.
                            $moduleInstance = \Nwidart\Modules\Facades\Module::findBy('display_name', $moduleDisplayName);
                            $moduleKey = $moduleInstance ? $moduleInstance->getName() : Str::slug($moduleDisplayName, '_'); // Fallback to slug if not found
                            $originalGroupNameForPerms = $moduleKey . '::' . $groupNameInModule;
                        ?>
                        <?php echo $__env->make('admin.settings.partials.settings-group-card', [
                            'groupDisplayName' => $groupNameInModule, // Display name for the card header within the module tab
                            'originalGroupName' => $originalGroupNameForPerms, // The actual group key for permissions
                            'settingsGroupedBySubGroup' => $settingsInGroup, // This is already sub-grouped from controller
                            'groupDescription' => $groupDescriptions[$originalGroupNameForPerms] ?? 'Manage ' . strtolower($groupNameInModule) . ' settings for ' . $moduleDisplayName . '.',
                            'canEditGroup' => Auth::user()->isSuperAdmin() || (Auth::user()->hasRole('admin') && \App\Models\SettingGroupPermission::where('role_name', 'admin')->where('setting_group_name', $originalGroupNameForPerms)->where('can_edit', true)->exists())
                        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- Save All Settings Button (Common for all tabs) -->
        <div class="pt-8">
            <div class="flex justify-start">
                <button type="submit" class="inline-flex justify-center py-2.5 px-6 border border-transparent shadow-sm text-sm font-medium rounded-lg text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 dark:bg-blue-500 dark:hover:bg-blue-600 dark:focus:ring-offset-gray-800 transition-colors">
                    Save All Settings
                </button>
            </div>
        </div>

    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const sendTestMailBtn = document.getElementById('sendTestMailBtn');
    const testMailStatus = document.getElementById('testMailStatus');

    if (sendTestMailBtn) {
        sendTestMailBtn.addEventListener('click', function () {
            sendTestMailBtn.disabled = true;
            sendTestMailBtn.classList.add('opacity-50', 'cursor-not-allowed');
            testMailStatus.textContent = 'Sending test email...';
            testMailStatus.className = 'mt-3 text-sm text-gray-600 dark:text-gray-400';


            fetch('<?php echo e(route('admin.settings.testMail')); ?>', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Accept': 'application/json',
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    testMailStatus.textContent = 'Success: ' + data.message;
                    testMailStatus.className = 'mt-3 text-sm text-green-600 dark:text-green-400';
                } else {
                    testMailStatus.textContent = 'Error: ' + (data.message || 'Failed to send test email.');
                    testMailStatus.className = 'mt-3 text-sm text-red-600 dark:text-red-400';
                }
            })
            .catch(error => {
                console.error('Error:', error);
                testMailStatus.textContent = 'Error: An unexpected error occurred.';
                testMailStatus.className = 'mt-3 text-sm text-red-600 dark:text-red-400';
            })
            .finally(() => {
                sendTestMailBtn.disabled = false;
                sendTestMailBtn.classList.remove('opacity-50', 'cursor-not-allowed');
            });
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\projects\digitalvocano\resources\views/admin/settings/index.blade.php ENDPATH**/ ?>