

<?php $__env->startSection('title', 'Paystack Gateway Settings'); ?>
<?php $__env->startSection('header_title', 'Paystack Gateway Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        <?php echo $__env->make('admin.partials.alerts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 

        <form action="<?php echo e(route('admin.paystackgateway.settings.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Enable Paystack -->
                <div class="md:col-span-2">
                     <?php
                        $id = 'paystack_enabled';
                        $name = 'paystack_enabled';
                        $label = 'Enable Paystack Gateway';
                        $value = '1';
                        $checked = old('paystack_enabled', $settings['paystack_enabled'] ?? '0') == '1';
                        $helpText = 'Toggle this to activate or deactivate the Paystack payment gateway.';
                    ?>
                    <label for="<?php echo e($id); ?>" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1"><?php echo e($label); ?></label>
                    <label class="relative inline-flex items-center cursor-pointer mt-1">
                        <input type="checkbox" id="<?php echo e($id); ?>" name="<?php echo e($name); ?>" class="sr-only peer" value="<?php echo e($value); ?>" <?php echo e($checked ? 'checked' : ''); ?>>
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                    </label>
                    <?php if($helpText): ?>
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400"><?php echo e($helpText); ?></p>
                    <?php endif; ?>
                    <?php $__errorArgs = ['paystack_enabled'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Paystack Mode -->
                <div>
                    <label for="paystack_mode" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Paystack Mode</label>
                    <select name="paystack_mode" id="paystack_mode" required
                            class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                        <option value="test" <?php echo e(old('paystack_mode', $settings['paystack_mode'] ?? 'test') == 'test' ? 'selected' : ''); ?>>Test</option>
                        <option value="live" <?php echo e(old('paystack_mode', $settings['paystack_mode'] ?? '') == 'live' ? 'selected' : ''); ?>>Live</option>
                    </select>
                    <?php $__errorArgs = ['paystack_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div></div> 

                <!-- Paystack Public Key -->
                <div>
                    <label for="paystack_public_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Paystack Public Key</label>
                    <input type="text" name="paystack_public_key" id="paystack_public_key" value="<?php echo e(old('paystack_public_key', $settings['paystack_public_key'] ?? '')); ?>"
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                    <?php $__errorArgs = ['paystack_public_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Paystack Secret Key -->
                <div>
                    <label for="paystack_secret_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Paystack Secret Key</label>
                    <input type="password" name="paystack_secret_key" id="paystack_secret_key" value="" 
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500"
                           placeholder="Leave blank to keep current secret">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Enter a new secret to update it. Leave blank to keep the existing one.</p>
                    <?php $__errorArgs = ['paystack_secret_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

            </div>

            <div class="mt-8 flex justify-end">
                <button type="submit" class="inline-flex items-center px-4 py-2 bg-gray-800 dark:bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-white dark:text-gray-800 uppercase tracking-widest hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                    Save Settings
                </button>
            </div>
        </form>
    </div>
</div>

<style>
    /* Simple toggle switch style */
    input:checked ~ .dot {
        transform: translateX(100%);
        background-color: #48bb78; /* green-500 */
    }
    input:checked ~ .block {
        background-color: #a0aec0; /* gray-400 */
    }
    /* Dark mode for toggle */
    .dark input:checked ~ .dot {
        background-color: #38a169; /* green-600 */
    }
    .dark input:checked ~ .block {
        background-color: #4a5568; /* gray-600 */
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\projects\digitalvocano\Modules/PaystackGateway\resources/views/admin/config.blade.php ENDPATH**/ ?>