

<?php $__env->startSection('title', 'Pricing Plans - WebPilot AI Website Builder'); ?>
<?php $__env->startSection('meta_description', 'Choose the perfect WebPilot AI plan for your needs. Explore our flexible pricing options for individuals, businesses, and agencies.'); ?>
<?php $__env->startSection('meta_keywords', 'webpilot ai pricing, ai website builder cost, subscription plans, website builder packages'); ?>

<?php $__env->startSection('content'); ?>
<div class="py-12 md:py-20 bg-white dark:bg-gray-800">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="text-center mb-16">
            <h1 class="text-4xl sm:text-5xl font-extrabold text-gray-800 dark:text-white leading-tight">
                Simple, Transparent Pricing
            </h1>
            <p class="mt-6 text-lg sm:text-xl text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Find the perfect plan to unlock the full potential of AI-powered website creation.
            </p>
        </header>

        
        <?php if($subscriptionPlans->isEmpty()): ?>
            <div class="text-center py-12">
                <svg xmlns="http://www.w3.org/2000/svg" class="mx-auto h-16 w-16 text-gray-400 dark:text-gray-500" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <h3 class="mt-2 text-xl font-medium text-gray-900 dark:text-white">No Pricing Plans Available</h3>
                <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">We are currently updating our pricing. Please check back soon!</p>
            </div>
        <?php else: ?>
            <?php
                $numPlans = $subscriptionPlans->count();
                $gridClasses = 'grid-cols-1'; // Default: 1 column on small screens
                if ($numPlans >= 2) {
                    $gridClasses .= ' md:grid-cols-2'; // 2 columns on medium screens if 2+ plans
                }
                if ($numPlans >= 3) {
                    $gridClasses .= ' lg:grid-cols-3'; // 3 columns on large screens if 3+ plans
                }
            ?>
            <div class="grid <?php echo e($gridClasses); ?> gap-6 md:gap-8 max-w-7xl mx-auto">
                <?php $__currentLoopData = $subscriptionPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $isPopular = (bool) $plan->is_popular;
                    $cardClasses = $isPopular
                        ? 'bg-blue-600 dark:bg-blue-700 text-white ring-2 ring-blue-500 dark:ring-blue-600 transform scale-105 hover:shadow-2xl' // Popular plan already scaled
                        : 'bg-slate-50 dark:bg-slate-700 border border-slate-200 dark:border-slate-600 hover:scale-[1.02] hover:shadow-2xl'; // Non-popular plan hover effect

                    $buttonClasses = $isPopular
                        ? 'bg-white hover:bg-blue-50 text-blue-600'
                        : ($plan->price == 0 ? 'bg-slate-200 dark:bg-slate-600 hover:bg-slate-300 dark:hover:bg-slate-500 text-gray-700 dark:text-white' : 'bg-blue-600 hover:bg-blue-700 text-white');

                    $planTitle = $plan->name;
                    if ($plan->target_role) {
                        $planTitle = Illuminate\Support\Str::title(str_replace('_', ' ', $plan->target_role)) . ' ' . $plan->name;
                    }
                    $planNameColor = $isPopular ? 'text-white' : ($plan->price == 0 ? 'text-blue-600 dark:text-blue-400' : ($isPopular ? 'text-white' : 'text-purple-600 dark:text-purple-400'));

                    $priceColor = $isPopular ? 'text-white' : 'text-gray-800 dark:text-white';
                    $featureTextColor = $isPopular ? 'opacity-90' : 'text-gray-600 dark:text-gray-300';
                    $featureIconColor = $isPopular ? 'text-green-300' : 'text-green-500';
                    $descriptionColor = $isPopular ? 'text-blue-100' : 'text-gray-500 dark:text-gray-400';
                    $initialFeaturesToShow = 5;
                ?>
                <div x-data="{ showFeaturesModal: false }" class="<?php echo e($cardClasses); ?> p-6 rounded-xl shadow-xl flex flex-col relative transition-all duration-300">
                    <?php if($isPopular): ?>
                        <span class="absolute top-0 left-1/2 -translate-x-1/2 -translate-y-1/2 bg-yellow-400 text-yellow-900 px-3 py-1 text-sm font-semibold rounded-full shadow-md">Most Popular</span>
                    <?php endif; ?>
                    <div class="text-center">
                        <h3 class="text-2xl font-bold <?php echo e($planNameColor); ?> mb-1"><?php echo e($planTitle); ?></h3>
                        <p class="text-4xl font-extrabold <?php echo e($priceColor); ?> mb-2">
                            <?php echo e($plan->currency_symbol ?? '$'); ?><?php echo e(number_format($plan->price, 2)); ?>

                            <span class="text-base font-medium <?php echo e($isPopular ? 'opacity-80' : 'text-gray-500 dark:text-gray-400'); ?>">
                                /<?php echo e($plan->interval_count > 1 ? $plan->interval_count . ' ' : ''); ?><?php echo e(Illuminate\Support\Str::ucfirst(Illuminate\Support\Str::plural($plan->interval, $plan->interval_count))); ?>

                            </span>
                        </p>
                        <p class="text-sm <?php echo e($descriptionColor); ?> mb-6 min-h-[40px] px-2"><?php echo e($plan->description); ?></p>
                    </div>

                    <div class="border-t <?php echo e($isPopular ? 'border-blue-400 dark:border-blue-500' : 'border-gray-200 dark:border-gray-600'); ?> my-4"></div>

                    <div class="flex-grow mb-6">
                    <?php if($plan->features && count($plan->features) > 0): ?>
                            <h4 class="text-sm font-semibold <?php echo e($featureTextColor); ?> mb-2">Key Features:</h4>
                        <ul class="space-y-1.5 <?php echo e($featureTextColor); ?> text-sm">
                            <?php $__currentLoopData = collect($plan->features)->take($initialFeaturesToShow); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featureItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $featureKey = $featureItem['key'];
                                    $featureLimit = $featureItem['limit'] ?? null;
                                    $featureDisplayName = Illuminate\Support\Str::title(str_replace(['_', '-'], ' ', $featureKey));

                                    // Attempt to find the feature's display name from module definitions
                                    foreach (($moduleDefinitions ?? []) as $moduleData) { // Added ?? [] for safety if undefined
                                        if (isset($moduleData['features'][$featureKey]['name'])) {
                                            $featureDisplayName = $moduleData['features'][$featureKey]['name'];
                                            break;
                                        }
                                    }
                                ?>
                                <li class="flex items-start">
                                    <svg class="w-4 h-4 <?php echo e($featureIconColor); ?> mr-2 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                    <?php echo e($featureDisplayName); ?>

                                    <?php if(!is_null($featureLimit)): ?>
                                        <span class="ml-1 text-xs <?php echo e($isPopular ? 'opacity-70' : 'text-gray-400 dark:text-gray-500'); ?>">(<?php echo e($featureLimit == 0 ? 'Unlimited' : $featureLimit); ?>)</span>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if(count($plan->features) > $initialFeaturesToShow): ?>
                                <li class="mt-2">
                                    <button @click="showFeaturesModal = true" class="text-xs font-semibold <?php echo e($isPopular ? 'text-blue-200 hover:text-white' : 'text-blue-500 hover:text-blue-700 dark:text-blue-400 dark:hover:text-blue-300'); ?> transition-colors duration-150">
                                        + <?php echo e(count($plan->features) - $initialFeaturesToShow); ?> more features (View all)
                                    </button>
                                </li>
                            <?php endif; ?>
                        </ul>
                    <?php else: ?>
                        <div class="min-h-[80px]"></div> 
                    <?php endif; ?>
                    </div>

                    
                    <?php if($plan->credits_awarded_on_purchase > 0 || $plan->credits_awarded_on_renewal > 0): ?>
                    <div class="mt-auto pt-3 border-t <?php echo e($isPopular ? 'border-blue-400 dark:border-blue-500' : 'border-gray-200 dark:border-gray-600'); ?> text-sm <?php echo e($featureTextColor); ?>">
                        <p class="font-semibold mb-1 text-xs uppercase tracking-wider">Credits Included:</p>
                        <?php if($plan->credits_awarded_on_purchase > 0): ?>
                            <span class="block ml-2 text-xs">&bull; On Purchase: <?php echo e(number_format($plan->credits_awarded_on_purchase)); ?></span>
                        <?php endif; ?>
                        <?php if($plan->credits_awarded_on_renewal > 0): ?>
                            <span class="block ml-2 text-xs">&bull; On Renewal: <?php echo e(number_format($plan->credits_awarded_on_renewal)); ?></span>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>

                    <?php if($plan->trial_period_days > 0): ?>
                        <p class="text-xs text-center <?php echo e($isPopular ? 'opacity-80' : 'text-gray-500 dark:text-gray-400'); ?> mb-3"><?php echo e($plan->trial_period_days); ?>-day free trial available</p>
                    <?php endif; ?>

                    
                    <div class="mt-6"> 
                    <?php if(auth()->guard()->check()): ?>
                            <a href="<?php echo e(route('subscription.checkout', $plan->slug)); ?>" class="<?php echo e($buttonClasses); ?> w-full block text-center font-semibold py-3 px-6 rounded-lg transition-colors duration-300">
                            Choose Plan
                        </a>
                    <?php else: ?>
                            <a href="<?php echo e(route('register', ['plan' => $plan->slug])); ?>" class="<?php echo e($buttonClasses); ?> w-full block text-center font-semibold py-3 px-6 rounded-lg transition-colors duration-300">
                            <?php echo e($plan->price == 0 ? 'Get Started Free' : 'Sign Up'); ?>

                        </a>
                    <?php endif; ?>
                </div>

                
                <div x-show="showFeaturesModal"
                     x-transition:enter="ease-out duration-300"
                     x-transition:enter-start="opacity-0"
                     x-transition:enter-end="opacity-100"
                     x-transition:leave="ease-in duration-200"
                     x-transition:leave-start="opacity-100"
                     x-transition:leave-end="opacity-0"
                     class="fixed inset-0 z-50 overflow-y-auto bg-black bg-opacity-75 flex items-center justify-center p-4"
                     @click.away="showFeaturesModal = false"
                     x-cloak
                >
                    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-xl p-6 w-full max-w-md transform transition-all" @click.stop>
                        <div class="flex justify-between items-center mb-4">
                            <h4 class="text-xl font-semibold text-gray-800 dark:text-white">All Features for <?php echo e($planTitle); ?></h4>
                            <button @click="showFeaturesModal = false" class="text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 transition-colors">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                            </button>
                        </div>
                        <ul class="space-y-2 text-gray-600 dark:text-gray-300 max-h-[60vh] overflow-y-auto pr-2">
                            <?php $__currentLoopData = $plan->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featureItemModal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $featureKeyModal = $featureItemModal['key'];
                                    $featureLimitModal = $featureItemModal['limit'] ?? null;
                                    $featureDisplayNameModal = Illuminate\Support\Str::title(str_replace(['_', '-'], ' ', $featureKeyModal));
                                    foreach (($moduleDefinitions ?? []) as $moduleDataModal) { // Added ?? [] for safety
                                        if (isset($moduleDataModal['features'][$featureKeyModal]['name'])) {
                                            $featureDisplayNameModal = $moduleDataModal['features'][$featureKeyModal]['name'];
                                            break;
                                        }
                                    }
                                ?>
                                <li class="flex items-start py-1 border-b border-gray-200 dark:border-gray-700 last:border-b-0">
                                    <svg class="w-5 h-5 text-green-500 dark:text-green-400 mr-3 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                                    <span>
                                        <?php echo e($featureDisplayNameModal); ?>

                                        <?php if(!is_null($featureLimitModal)): ?>
                                            <span class="ml-1 text-xs text-gray-400 dark:text-gray-500">(<?php echo e($featureLimitModal == 0 ? 'Unlimited' : $featureLimitModal); ?>)</span>
                                        <?php endif; ?>
                                    </span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div> 
                </div> 
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>

        <div class="mt-16 text-center text-gray-600 dark:text-gray-400">
            <p>All plans include access to our intuitive visual editor, SEO assistant, and website version history.</p>
            <p>Need a custom solution? <a href="<?php echo e(route('frontend.contact.form')); ?>" class="text-blue-500 hover:underline">Get in touch</a> with us!</p>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\projects\digitalvocano\Modules/WebPilotAI\resources/views/frontend/pages/pricing.blade.php ENDPATH**/ ?>