 

<?php $__env->startSection('title', 'PayPal Gateway Settings'); ?>
<?php $__env->startSection('header_title', 'PayPal Gateway Configuration'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        <h1 class="text-2xl font-medium text-gray-900 dark:text-white mb-6">
            PayPal Settings
        </h1>

        <?php echo $__env->make('admin.partials.alerts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 

        <form action="<?php echo e(route('admin.paypalgateway.settings.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="space-y-6">
                <!-- Enable PayPal -->
                <div>
                    <?php
                        $id = 'paypal_enabled';
                        $name = 'paypal_enabled';
                        $label = 'Enable PayPal Gateway';
                        $value = '1';
                        $checked = old('paypal_enabled', $settings['paypal_enabled'] ?? '0') == '1';
                        $helpText = 'Toggle this to activate or deactivate the PayPal payment gateway.';
                    ?>
                    <label for="<?php echo e($id); ?>" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1"><?php echo e($label); ?></label>
                    <label class="relative inline-flex items-center cursor-pointer mt-1">
                        <input type="checkbox" id="<?php echo e($id); ?>" name="<?php echo e($name); ?>" class="sr-only peer" value="<?php echo e($value); ?>" <?php echo e($checked ? 'checked' : ''); ?>>
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                    </label>
                    <?php if($helpText): ?>
                        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400"><?php echo e($helpText); ?></p>
                    <?php endif; ?>
                    <?php $__errorArgs = [$name];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- PayPal Mode -->
                <div>
                    <label for="paypal_mode" class="block text-sm font-medium text-gray-700 dark:text-gray-300">PayPal Mode</label>
                    <select name="paypal_mode" id="paypal_mode" required
                            class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                        <option value="sandbox" <?php echo e(old('paypal_mode', $settings['paypal_mode'] ?? 'sandbox') == 'sandbox' ? 'selected' : ''); ?>>Sandbox (Testing)</option>
                        <option value="live" <?php echo e(old('paypal_mode', $settings['paypal_mode'] ?? '') == 'live' ? 'selected' : ''); ?>>Live (Production)</option>
                    </select>
                    <?php $__errorArgs = ['paypal_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- PayPal Client ID -->
                <div>
                    <label for="paypal_client_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">PayPal Client ID</label>
                    <input type="text" name="paypal_client_id" id="paypal_client_id" value="<?php echo e(old('paypal_client_id', $settings['paypal_client_id'] ?? '')); ?>"
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    <?php $__errorArgs = ['paypal_client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- PayPal Client Secret -->
                <div>
                    <label for="paypal_client_secret" class="block text-sm font-medium text-gray-700 dark:text-gray-300">PayPal Client Secret</label>
                    <input type="password" name="paypal_client_secret" id="paypal_client_secret" value="" 
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm"
                           placeholder="Leave blank to keep current secret">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Enter a new secret to update it. Leave blank to keep the existing one.</p>
                    <?php $__errorArgs = ['paypal_client_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- PayPal Webhook ID -->
                <div>
                    <label for="paypal_webhook_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">PayPal Webhook ID</label>
                    <input type="text" name="paypal_webhook_id" id="paypal_webhook_id" value="<?php echo e(old('paypal_webhook_id', $settings['paypal_webhook_id'] ?? '')); ?>"
                           class="mt-1 block w-full border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Get this from your PayPal Developer Dashboard after creating a webhook.</p>
                    <?php $__errorArgs = ['paypal_webhook_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

            </div>

            <div class="mt-8 flex justify-end">
                <button type="submit"
                        class="inline-flex items-center px-4 py-2 bg-gray-800 dark:bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-white dark:text-gray-800 uppercase tracking-widest hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                    Save Settings
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\projects\digitalvocano\Modules/PaypalGateway\resources/views/admin/config.blade.php ENDPATH**/ ?>