

<?php $__env->startSection('title', 'Features - WebPilot AI Website Builder'); ?>
<?php $__env->startSection('meta_description', 'Discover the powerful AI-driven features of WebPilot AI that help you build stunning websites in minutes. From intelligent design to easy customization and deployment.'); ?>
<?php $__env->startSection('meta_keywords', 'ai website features, webpilot ai features, intelligent design, ai content generation, ai image studio, no-code editor, easy deployment'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-gradient-to-b from-slate-50 dark:from-slate-900 to-white dark:to-gray-800 py-12 md:py-20">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <header class="text-center mb-16">
            <h1 class="text-4xl sm:text-5xl font-extrabold text-gray-800 dark:text-white leading-tight">
                Powerful Features, Effortless Creation
            </h1>
            <p class="mt-6 text-lg sm:text-xl text-gray-600 dark:text-gray-300 max-w-3xl mx-auto">
                WebPilot AI is packed with cutting-edge tools to make your website building experience seamless and effective.
            </p>
        </header>

        
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8 lg:gap-12">
            
            <div class="bg-white dark:bg-gray-800 p-8 rounded-xl shadow-xl hover:shadow-2xl transition-shadow duration-300">
                <div class="text-blue-500 dark:text-blue-400 mb-5">
                    
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" stroke-linejoin="round" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" /></svg>
                </div>
                <h3 class="text-2xl font-semibold text-gray-700 dark:text-white mb-3">AI Website Generation</h3>
                <p class="text-gray-500 dark:text-gray-400">
                    Describe your vision, and our AI crafts a unique, professional website in minutes. Perfect for any industry or purpose.
                </p>
            </div>

            
            <div class="bg-white dark:bg-gray-800 p-8 rounded-xl shadow-xl hover:shadow-2xl transition-shadow duration-300">
                <div class="text-green-500 dark:text-green-400 mb-5">
                     <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" stroke-linejoin="round" d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10" /></svg>
                </div>
                <h3 class="text-2xl font-semibold text-gray-700 dark:text-white mb-3">AI Content Writer</h3>
                <p class="text-gray-500 dark:text-gray-400">
                    Generate compelling headlines, paragraphs, product descriptions, and more with our integrated AI writing assistant.
                </p>
            </div>

            
            <div class="bg-white dark:bg-gray-800 p-8 rounded-xl shadow-xl hover:shadow-2xl transition-shadow duration-300">
                <div class="text-purple-500 dark:text-purple-400 mb-5">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" stroke-linejoin="round" d="M2.25 15.75l5.159-5.159a2.25 2.25 0 013.182 0l5.159 5.159m-1.5-1.5l1.409-1.409a2.25 2.25 0 013.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 001.5-1.5V6a1.5 1.5 0 00-1.5-1.5H3.75A1.5 1.5 0 002.25 6v12a1.5 1.5 0 001.5 1.5zm10.5-11.25h.008v.008h-.008V8.25zm.375 0a.375.375 0 11-.75 0 .375.375 0 01.75 0z" /></svg>
                </div>
                <h3 class="text-2xl font-semibold text-gray-700 dark:text-white mb-3">AI Image Studio</h3>
                <p class="text-gray-500 dark:text-gray-400">
                    Create unique images from text prompts or access a vast library of stock photos to make your website visually stunning.
                </p>
            </div>

            
            <div class="bg-white dark:bg-gray-800 p-8 rounded-xl shadow-xl hover:shadow-2xl transition-shadow duration-300">
                <div class="text-yellow-500 dark:text-yellow-400 mb-5">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" stroke-linejoin="round" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" /></svg>
                </div>
                <h3 class="text-2xl font-semibold text-gray-700 dark:text-white mb-3">Intuitive Visual Editor</h3>
                <p class="text-gray-500 dark:text-gray-400">
                    No coding required! Easily customize every aspect of your site with our drag-and-drop interface and real-time previews.
                </p>
            </div>

            
            <div class="bg-white dark:bg-gray-800 p-8 rounded-xl shadow-xl hover:shadow-2xl transition-shadow duration-300">
                <div class="text-pink-500 dark:text-pink-400 mb-5">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 6A2.25 2.25 0 016 3.75h2.25A2.25 2.25 0 0110.5 6v2.25a2.25 2.25 0 01-2.25 2.25H6a2.25 2.25 0 01-2.25-2.25V6zM3.75 15.75A2.25 2.25 0 016 13.5h2.25a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 018.25 20.25H6A2.25 2.25 0 013.75 18v-2.25zM13.5 6a2.25 2.25 0 012.25-2.25H18A2.25 2.25 0 0120.25 6v2.25A2.25 2.25 0 0118 10.5h-2.25A2.25 2.25 0 0113.5 8.25V6zM13.5 15.75a2.25 2.25 0 012.25-2.25H18a2.25 2.25 0 012.25 2.25V18A2.25 2.25 0 0118 20.25h-2.25A2.25 2.25 0 0113.5 18v-2.25z" /></svg>
                </div>
                <h3 class="text-2xl font-semibold text-gray-700 dark:text-white mb-3">Rich Template Library</h3>
                <p class="text-gray-500 dark:text-gray-400">
                    Start with professionally designed AI templates and style presets, or build from scratch. Endless possibilities.
                </p>
            </div>

            
            <div class="bg-white dark:bg-gray-800 p-8 rounded-xl shadow-xl hover:shadow-2xl transition-shadow duration-300">
                <div class="text-teal-500 dark:text-teal-400 mb-5">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="1.5"><path stroke-linecap="round" stroke-linejoin="round" d="M13 10V3L4 14h7v7l9-11h-7z" /></svg>
                </div>
                <h3 class="text-2xl font-semibold text-gray-700 dark:text-white mb-3">One-Click Deployment</h3>
                <p class="text-gray-500 dark:text-gray-400">
                    Download your website as a ZIP or deploy directly to your cPanel, FTP, or SFTP hosting with a single click.
                </p>
            </div>
        </div>

        <section class="text-center mt-20">
            <a href="<?php echo e(route('register')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-4 px-10 rounded-lg text-xl shadow-lg hover:shadow-xl transition-all duration-300">
                Explore WebPilot AI Now
            </a>
        </section>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\projects\digitalvocano\Modules/WebPilotAI\resources/views/frontend/pages/features.blade.php ENDPATH**/ ?>