

<?php $__env->startSection('title', 'Authorize.Net Gateway Settings'); ?>
<?php $__env->startSection('header_title', 'Authorize.Net Gateway Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
    <div class="p-6 lg:p-8">
        <?php echo $__env->make('admin.partials.alerts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> 

        <form action="<?php echo e(route('admin.authorizenetgateway.settings.update')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Enable Authorize.Net -->
                <div class="md:col-span-2">
                    <label for="authorizenet_enabled" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Enable Authorize.Net Gateway</label>
                    <label class="relative inline-flex items-center cursor-pointer mt-1">
                        <input type="checkbox" id="authorizenet_enabled" name="authorizenet_enabled" class="sr-only peer" value="1" <?php echo e(old('authorizenet_enabled', $settings['authorizenet_enabled'] ?? '0') == '1' ? 'checked' : ''); ?>>
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                        <span class="ml-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                            Enable Authorize.Net Gateway
                        </span>
                    </label>
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                        Toggle this to activate or deactivate the Authorize.Net payment gateway across the platform.
                    </p>
                    <?php $__errorArgs = ['authorizenet_enabled'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Authorize.Net Mode -->
                <div>
                    <label for="authorizenet_mode" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Authorize.Net Mode</label>
                    <select name="authorizenet_mode" id="authorizenet_mode" required
                            class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                        <option value="sandbox" <?php echo e(old('authorizenet_mode', $settings['authorizenet_mode'] ?? 'sandbox') == 'sandbox' ? 'selected' : ''); ?>>Sandbox (Test Environment)</option>
                        <option value="live" <?php echo e(old('authorizenet_mode', $settings['authorizenet_mode'] ?? '') == 'live' ? 'selected' : ''); ?>>Live (Production)</option>
                    </select>
                    <?php $__errorArgs = ['authorizenet_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                 <div></div> 


                <!-- Authorize.Net API Login ID -->
                <div>
                    <label for="authorizenet_login_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300">API Login ID</label>
                    <input type="text" name="authorizenet_login_id" id="authorizenet_login_id" value="<?php echo e(old('authorizenet_login_id', $settings['authorizenet_login_id'] ?? '')); ?>"
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                    <?php $__errorArgs = ['authorizenet_login_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Authorize.Net Transaction Key -->
                <div>
                    <label for="authorizenet_transaction_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Transaction Key</label>
                    <input type="password" name="authorizenet_transaction_key" id="authorizenet_transaction_key" value="<?php echo e(old('authorizenet_transaction_key', $settings['authorizenet_transaction_key'] ?? '')); ?>"
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                    <?php $__errorArgs = ['authorizenet_transaction_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- Authorize.Net Public Client Key -->
                <div>
                    <label for="authorizenet_public_client_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Public Client Key</label>
                    <input type="text" name="authorizenet_public_client_key" id="authorizenet_public_client_key" value="<?php echo e(old('authorizenet_public_client_key', $settings['authorizenet_public_client_key'] ?? '')); ?>"
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Used for Accept.js integration. Obtain this from your Authorize.Net Merchant Interface.</p>
                    <?php $__errorArgs = ['authorizenet_public_client_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <!-- Authorize.Net Signature Key (for Webhooks) -->
                <div>
                    <label for="authorizenet_signature_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Signature Key (for Webhooks)</label>
                    <input type="password" name="authorizenet_signature_key" id="authorizenet_signature_key" value="<?php echo e(old('authorizenet_signature_key', $settings['authorizenet_signature_key'] ?? '')); ?>"
                           class="mt-1 block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 rounded-md focus:ring-indigo-500 focus:border-indigo-500">
                    <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">Used to verify webhook signatures. Obtain this from your Authorize.Net Merchant Interface.</p>
                    <?php $__errorArgs = ['authorizenet_signature_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-2 text-sm text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

            </div>

            <div class="mt-8 flex justify-end">
                <button type="submit" class="inline-flex items-center px-4 py-2 bg-gray-800 dark:bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-white dark:text-gray-800 uppercase tracking-widest hover:bg-gray-700 dark:hover:bg-white focus:bg-gray-700 dark:focus:bg-white active:bg-gray-900 dark:active:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                    Save Settings
                </button>
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\projects\digitalvocano\Modules/AuthorizeNetGateway\resources/views/admin/config.blade.php ENDPATH**/ ?>