




<div> 
    <h2 class="text-2xl font-semibold text-gray-800 dark:text-gray-200"><?php echo e($groupDisplayName); ?></h2>
    <?php if($groupDescription): ?>
        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400"><?php echo e($groupDescription); ?></p>
    <?php endif; ?>
</div>


<?php if($settingsGroupedBySubGroup->count() > 0): ?>
    <hr class="border-gray-200 dark:border-gray-700"> 
<?php endif; ?>


<?php $__empty_1 = true; $__currentLoopData = $settingsGroupedBySubGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subGroupName => $settingsInSubGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
            <h4 class="text-md font-semibold text-gray-800 dark:text-gray-200">
                <?php echo e($subGroupName); ?>

            </h4>
            
        </div>
        <div class="px-6 py-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-x-6 gap-y-8">
                <?php $__currentLoopData = $settingsInSubGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $settingKeyName = 'settings_values[' . $setting->key . ']'; ?>
                    <input type="hidden" name="settings_keys[]" value="<?php echo e($setting->key); ?>">

                    <div class="<?php echo e($setting->type === 'textarea' || $setting->type === 'checkbox' ? 'md:col-span-2' : 'md:col-span-1'); ?>">
                        <?php if($setting->type !== 'checkbox'): ?>
                            <label for="<?php echo e($settingKeyName); ?>" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1"><?php echo e($setting->name); ?></label>
                        <?php endif; ?>

                        <?php if($setting->type === 'text' || $setting->type === 'number' || $setting->type === 'email' || $setting->type === 'password'): ?>
                            <input type="<?php echo e($setting->type === 'password' ? 'password' : ($setting->type === 'number' ? 'number' : 'text')); ?>" name="<?php echo e($settingKeyName); ?>" id="<?php echo e($settingKeyName); ?>" value="<?php echo e(old($settingKeyName, $setting->type === 'password' ? '' : $setting->value)); ?>"
                                   class="block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-gray-200 focus:ring-blue-500 focus:border-blue-500 disabled:opacity-60 disabled:cursor-not-allowed"
                                   placeholder="<?php echo e($setting->type === 'password' ? 'Enter new password to change' : ($setting->placeholder ?? '')); ?>" <?php echo e(!$canEditGroup ? 'disabled' : ''); ?>>
                        <?php elseif($setting->type === 'textarea'): ?>
                            <textarea name="<?php echo e($settingKeyName); ?>" id="<?php echo e($settingKeyName); ?>" rows="4"
                                      class="block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-gray-200 focus:ring-blue-500 focus:border-blue-500 disabled:opacity-60 disabled:cursor-not-allowed" placeholder="<?php echo e($setting->placeholder ?? ''); ?>" <?php echo e(!$canEditGroup ? 'disabled' : ''); ?>><?php echo e(old($settingKeyName, $setting->value)); ?></textarea>
                        <?php elseif($setting->type === 'checkbox'): ?>
                            <label for="<?php echo e($settingKeyName); ?>_checkbox" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1"><?php echo e($setting->name); ?></label>
                            <div class="flex items-center mt-1">
                                <input type="hidden" name="<?php echo e($settingKeyName); ?>" value="0" <?php echo e(!$canEditGroup ? 'disabled' : ''); ?>>
                                <input id="<?php echo e($settingKeyName); ?>_checkbox" name="<?php echo e($settingKeyName); ?>" type="checkbox" value="1" <?php echo e(old($settingKeyName, $setting->value) == '1' ? 'checked' : ''); ?>

                                       class="focus:ring-blue-500 h-4 w-4 text-blue-600 border-gray-300 dark:border-gray-600 rounded dark:bg-gray-700 disabled:opacity-60 disabled:cursor-not-allowed" <?php echo e(!$canEditGroup ? 'disabled' : ''); ?>>
                                <label for="<?php echo e($settingKeyName); ?>_checkbox" class="ml-2 text-sm text-gray-700 dark:text-gray-300"><?php echo e($setting->placeholder ?: 'Enable'); ?></label>
                            </div>
                        <?php elseif($setting->type === 'file'): ?>
                            <input type="file" name="settings_files[<?php echo e($setting->key); ?>]" id="settings_files_<?php echo e($setting->key); ?>"
                                   class="block w-full text-sm text-gray-900 dark:text-gray-100 border border-gray-300 dark:border-gray-600 rounded-md cursor-pointer bg-gray-50 dark:bg-gray-700 focus:outline-none focus:border-blue-500 focus:ring-blue-500 file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-blue-50 dark:file:bg-blue-700 file:text-blue-700 dark:file:text-blue-100 hover:file:bg-blue-100 dark:hover:file:bg-blue-600 disabled:opacity-60 disabled:cursor-not-allowed" <?php echo e(!$canEditGroup ? 'disabled' : ''); ?>>
                            <?php if($setting->value && Storage::disk('public')->exists($setting->value)): ?>
                                <div class="mt-2 text-sm">
                                    <span class="text-gray-500 dark:text-gray-400">Current:</span>
                                    <?php if(in_array(strtolower(pathinfo($setting->value, PATHINFO_EXTENSION)), ['png', 'jpg', 'jpeg', 'gif', 'svg', 'ico', 'webp'])): ?>
                                        <img src="<?php echo e(Storage::url($setting->value)); ?>" alt="<?php echo e($setting->name); ?>" class="h-16 mt-1 max-w-xs object-contain rounded-md border dark:border-gray-600">
                                    <?php else: ?>
                                        <a href="<?php echo e(Storage::url($setting->value)); ?>" target="_blank" class="ml-1 text-blue-600 hover:text-blue-800 dark:text-blue-400 dark:hover:text-blue-300 underline"><?php echo e(basename($setting->value)); ?></a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php elseif($setting->type === 'select' && isset($setting->options) && is_array($setting->options)): ?>
                            <select name="<?php echo e($settingKeyName); ?>" id="<?php echo e($settingKeyName); ?>" class="block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md dark:bg-gray-700 dark:text-gray-200 disabled:opacity-60 disabled:cursor-not-allowed" <?php echo e(!$canEditGroup ? 'disabled' : ''); ?>>
                                <?php if($setting->placeholder): ?>
                                    <option value=""><?php echo e($setting->placeholder); ?></option>
                                <?php endif; ?>
                                <?php $__currentLoopData = $setting->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $optValue => $optLabel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($optValue); ?>" <?php echo e(old($settingKeyName, $setting->value) == $optValue ? 'selected' : ''); ?>><?php echo e($optLabel); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        <?php else: ?> 
                            <input type="text" name="<?php echo e($settingKeyName); ?>" id="<?php echo e($settingKeyName); ?>" value="<?php echo e(old($settingKeyName, $setting->value)); ?>"
                                   class="block w-full shadow-sm sm:text-sm border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-gray-200 focus:ring-blue-500 focus:border-blue-500 disabled:opacity-60 disabled:cursor-not-allowed" placeholder="<?php echo e($setting->placeholder ?? ''); ?>" <?php echo e(!$canEditGroup ? 'disabled' : ''); ?>>
                        <?php endif; ?>
                        <div class="mt-1">
                            <?php $__errorArgs = [$settingKeyName];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-xs text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <?php $__errorArgs = ['settings_files.' . $setting->key];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-xs text-red-600 dark:text-red-400"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <?php if($setting->description): ?>
                            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400"><?php echo e($setting->description); ?></p>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    
    
    <div class="bg-white dark:bg-gray-800 shadow-xl rounded-xl overflow-hidden p-6">
        <p class="text-center text-gray-500 dark:text-gray-400">No settings are available in the '<?php echo e($groupDisplayName); ?>' group.</p>
    </div>
<?php endif; ?>
<?php /**PATH D:\projects\digitalvocano\resources\views/admin/settings/partials/settings-group-card.blade.php ENDPATH**/ ?>