<?php

use Illuminate\Support\Facades\Route;
// No need to import Setting model here if using the setting() helper
use App\Http\Controllers\Auth\SocialLoginController; // Add this
use Nwidart\Modules\Facades\Module; // For checking module status
use App\Http\Controllers\User\TicketController as UserTicketController;
use App\Http\Controllers\SubscriptionController; // Add this
use App\Http\Controllers\User\DashboardController; // Add this line
use App\Http\Controllers\User\WalletController as UserWalletController; // Added
use App\Http\Controllers\User\CreditTransactionController as UserCreditTransactionController; // Added
use App\Http\Controllers\Frontend\ContactPageController; // Added for contact page
use App\Http\Controllers\User\CreditPurchaseController; // Added for credit top-up
use App\Http\Controllers\User\WalletTransactionController as UserWalletTransactionController; // Added

// Homepage Route Logic
$moduleClassExists = class_exists(Nwidart\Modules\Facades\Module::class);
$settingFunctionExists = function_exists('setting');

$landingPageIsActiveHomepageProvider = $moduleClassExists &&
                                     $settingFunctionExists &&
                                     Module::has('LandingPage') &&
                                     Module::isEnabled('LandingPage') &&
                                     setting('landing_page_enabled', '0') == '1';

if (!$landingPageIsActiveHomepageProvider) {
    // LandingPage is NOT the active homepage provider.
    // Try WebPilotAI first.
    if ($moduleClassExists && Module::has('WebPilotAI') && Module::isEnabled('WebPilotAI')) {
        Route::get('/', [\Modules\WebPilotAI\Http\Controllers\Frontend\HomepageController::class, 'index'])->name('home');
    }
    // If WebPilotAI is not active, try BusinessDirectory.
    elseif ($moduleClassExists && Module::has('BusinessDirectory') && Module::isEnabled('BusinessDirectory')) {
        Route::get('/', [\Modules\BusinessDirectory\Http\Controllers\Frontend\HomepageController::class, 'index'])->name('home');
    }
    // If neither WebPilotAI nor BusinessDirectory are active (and LandingPage is also not active),
    // then fallback to the login/dashboard redirect.
    else {
        Route::get('/', function () {
            if (auth()->check()) {
                return redirect()->route('dashboard');
            }
            return redirect()->route('login');
        })->name('home');
    }
} else {
    // LandingPage IS the active homepage provider.
    // Its routes are loaded last by the main RouteServiceProvider and should define '/'.
    // This block provides a fallback redirect if LandingPage's routes somehow don't define '/'.
    // This route will effectively be overridden if LandingPage defines its own 'home' named route or '/'.
    Route::get('/', function () {
        if (auth()->check()) {
            return redirect()->route('dashboard');
        }
        return redirect()->route('login');
    })->name('home');
}

Route::middleware([
    // 'auth:sanctum', // Typically not needed for web session routes; AuthenticateSession handles it.
    config('jetstream.auth_session'), // Uses the guard defined in config/jetstream.php (which is 'web')
    'verified',
])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // User Ticket Routes
    Route::get('/support/tickets', [UserTicketController::class, 'index'])->name('user.tickets.index');
    Route::get('/support/tickets/create', [UserTicketController::class, 'create'])->name('user.tickets.create');
    Route::post('/support/tickets', [UserTicketController::class, 'store'])->name('user.tickets.store');
    Route::get('/support/tickets/{ticket}', [UserTicketController::class, 'show'])->name('user.tickets.show');
    Route::post('/support/tickets/{ticket}/reply', [UserTicketController::class, 'reply'])->name('user.tickets.reply');
});

// Social Login Routes
Route::get('/auth/{provider}/redirect', [SocialLoginController::class, 'redirectToProvider'])->name('social.redirect');
Route::get('/auth/{provider}/callback', [SocialLoginController::class, 'handleProviderCallback'])->name('social.callback');

// Subscription Flow Routes (User-facing)
Route::middleware(['auth'])->group(function () {
    Route::get('/subscription-plans', [SubscriptionController::class, 'index'])->name('subscription.plans');
    Route::get('/subscribe/{subscriptionPlan:slug}', [SubscriptionController::class, 'showCheckout'])->name('subscription.checkout');
    // Process the subscription checkout
    Route::post('/subscribe/process/{subscriptionPlan:slug}', [SubscriptionController::class, 'processSubscription'])->name('subscription.process');

    // User Wallet Routes
    Route::get('/wallet/deposit', [UserWalletController::class, 'showDepositForm'])->name('user.wallet.deposit.form');
    Route::post('/wallet/deposit', [UserWalletController::class, 'processDeposit'])->name('user.wallet.deposit.process');
    Route::get('/wallet/withdraw', [UserWalletController::class, 'showWithdrawalForm'])->name('user.wallet.withdraw.form');
    Route::post('/wallet/withdraw', [UserWalletController::class, 'submitWithdrawalRequest'])->name('user.wallet.withdraw.submit');
    Route::get('/wallet/custom-deposit-instructions', [UserWalletController::class, 'showCustomDepositInstructions'])->name('user.wallet.customDepositInstructions');
    Route::get('/wallet/withdrawal-requests/{withdrawalRequest}', [UserWalletController::class, 'showWithdrawalRequest'])->name('wallet.withdrawal-requests.show');
    Route::get('/wallet/history', [UserWalletTransactionController::class, 'index'])->name('user.wallet.history');

    // User Credit History
    Route::get('/credits/history', [UserCreditTransactionController::class, 'index'])->name('user.credits.history');

    // User Credit Top-up
    Route::get('/credits/topup', [CreditPurchaseController::class, 'showTopupForm'])->name('user.credits.topup.form');
    Route::post('/credits/topup', [CreditPurchaseController::class, 'processTopup'])->name('user.credits.topup.process');

});

// Public Contact Page
Route::get('/contact-us', [ContactPageController::class, 'showContactForm'])->name('frontend.contact.form');
Route::post('/contact-us', [ContactPageController::class, 'submitContactForm'])->name('frontend.contact.submit');
