<?php

use App\Http\Middleware\VerifyAgentApiKey;
use App\Http\Controllers\Api\AgentController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Agent Communication Endpoint
Route::post('/agent/heartbeat', [AgentController::class, 'heartbeat'])
    ->name('api.agent.heartbeat') // Good practice to name routes
     ->middleware(VerifyAgentApiKey::class); // Or use the alias if you registered it in app/Http/Kernel.php

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
