<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Withdrawal Request Details') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-6 lg:p-8">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100">
                            Request #{{ $withdrawalRequest->id }}
                        </h3>
                        <a href="{{ route('user.wallet.history') }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
                            &larr; Back to Wallet History
                        </a>
                    </div>

                    @include('layouts.partials.flash-messages')

                    <dl class="grid grid-cols-1 sm:grid-cols-2 gap-x-4 gap-y-6">
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Amount</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $withdrawalRequest->currency }} {{ number_format($withdrawalRequest->amount, 2) }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Withdrawal Method</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ Str::title(str_replace('_', ' ', $withdrawalRequest->withdrawal_method)) }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Requested At</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $withdrawalRequest->created_at->format('M d, Y H:i:s') }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Current Status</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                    @if($withdrawalRequest->status === 'pending') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                    @elseif($withdrawalRequest->status === 'approved') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100
                                    @elseif($withdrawalRequest->status === 'processing') bg-indigo-100 text-indigo-800 dark:bg-indigo-700 dark:text-indigo-100
                                    @elseif($withdrawalRequest->status === 'completed') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                    @elseif($withdrawalRequest->status === 'rejected') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                    @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                    {{ $statuses[$withdrawalRequest->status] ?? Str::title($withdrawalRequest->status) }}
                                </span>
                            </dd>
                        </div>

                        @if($withdrawalRequest->processed_at)
                        <div>
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Processed At</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">{{ $withdrawalRequest->processed_at->format('M d, Y H:i:s') }}</dd>
                        </div>
                        @endif

                        <div class="sm:col-span-2">
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Payment Details Provided</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100">
                                <div class="bg-gray-50 dark:bg-gray-700 p-3 rounded-md text-xs">
                                    @if($withdrawalRequest->withdrawal_method === 'bank_transfer' && is_array($withdrawalRequest->payment_details))
                                        <p><strong>Bank Name:</strong> {{ $withdrawalRequest->payment_details['bank_name'] ?? 'N/A' }}</p>
                                        <p><strong>Account Holder:</strong> {{ $withdrawalRequest->payment_details['account_holder_name'] ?? 'N/A' }}</p>
                                        <p><strong>Account Number:</strong> {{ $withdrawalRequest->payment_details['account_number'] ?? 'N/A' }}</p>
                                        <p><strong>Branch/SWIFT/IBAN:</strong> {{ $withdrawalRequest->payment_details['branch_code'] ?? 'N/A' }}</p>
                                    @else
                                        <pre class="whitespace-pre-wrap">{{ json_encode($withdrawalRequest->payment_details, JSON_PRETTY_PRINT) }}</pre>
                                    @endif
                                </div>
                            </dd>
                        </div>

                        @if($withdrawalRequest->admin_notes)
                        <div class="sm:col-span-2">
                            <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Admin Notes</dt>
                            <dd class="mt-1 text-sm text-gray-900 dark:text-gray-100 prose dark:prose-invert max-w-none">{{ $withdrawalRequest->admin_notes }}</dd>
                        </div>
                        @endif
                    </dl>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>