<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Request Wallet Withdrawal') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-6 lg:p-8">
                    <div class="mb-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100">
                            {{ __('Current Wallet Balance') }}: {{ number_format($currentBalance, 2) }} {{ setting('wallet_default_currency', 'USD') }}
                        </h3>
                        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                            Minimum withdrawal amount: {{ number_format($minWithdrawal, 2) }} {{ setting('wallet_default_currency', 'USD') }}.
                            Withdrawals are processed manually and may take some time.
                        </p>
                    </div>

                    <form method="POST" action="{{ route('user.wallet.withdraw.submit') }}">
                        @csrf

                        <div>
                            <x-label for="amount" value="{{ __('Withdrawal Amount') }} ({{ setting('wallet_default_currency', 'USD') }})" />
                            <x-input id="amount" class="block mt-1 w-full" type="number" name="amount" :value="old('amount')" required autofocus step="0.01" min="{{ $minWithdrawal }}" max="{{ $currentBalance }}" />
                            {{-- Pass validation messages for 'amount' --}}
                            <x-input-error :messages="$errors->get('amount')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-label for="withdrawal_method" value="{{ __('Withdrawal Method') }}" />
                            <select name="withdrawal_method" id="withdrawal_method" class="block mt-1 w-full border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                                @foreach($withdrawalMethods as $key => $name)
                                    <option value="{{ $key }}" {{ old('withdrawal_method') == $key ? 'selected' : '' }}>{{ $name }}</option>
                                @endforeach
                            </select>
                            {{-- Pass validation messages for 'withdrawal_method' --}}
                            <x-input-error :messages="$errors->get('withdrawal_method')" class="mt-2" />
                        </div>

                        {{-- TODO: Add Alpine.js to show/hide these based on selected withdrawal_method if more methods are added --}}
                        {{-- For now, assuming only bank_transfer --}}
                        <div id="bank_transfer_details" class="mt-4 space-y-4">
                            <h4 class="text-md font-semibold text-gray-700 dark:text-gray-300">Bank Account Details</h4>
                            <div>
                                <x-label for="bank_name" value="{{ __('Bank Name') }}" />
                                <x-input id="bank_name" class="block mt-1 w-full" type="text" name="bank_name" :value="old('bank_name')" />
                                {{-- Pass validation messages for 'bank_name' --}}
                                <x-input-error :messages="$errors->get('bank_name')" class="mt-2" />
                            </div>

                            <div>
                                <x-label for="account_holder_name" value="{{ __('Account Holder Name') }}" />
                                <x-input id="account_holder_name" class="block mt-1 w-full" type="text" name="account_holder_name" :value="old('account_holder_name')" />
                                {{-- Pass validation messages for 'account_holder_name' --}}
                                <x-input-error :messages="$errors->get('account_holder_name')" class="mt-2" />
                            </div>

                            <div>
                                <x-label for="account_number" value="{{ __('Account Number') }}" />
                                <x-input id="account_number" class="block mt-1 w-full" type="text" name="account_number" :value="old('account_number')" />
                                {{-- Pass validation messages for 'account_number' --}}
                                <x-input-error :messages="$errors->get('account_number')" class="mt-2" />
                            </div>

                            <div>
                                <x-label for="branch_code" value="{{ __('Branch Code / SWIFT / IBAN (if applicable)') }}" />
                                <x-input id="branch_code" class="block mt-1 w-full" type="text" name="branch_code" :value="old('branch_code')" />
                                {{-- Pass validation messages for 'branch_code' --}}
                                <x-input-error :messages="$errors->get('branch_code')" class="mt-2" />
                            </div>
                        </div>

                        <div class="flex items-center justify-end mt-6">
                            <x-button>
                                {{ __('Submit Withdrawal Request') }}
                            </x-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>