<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('My Wallet Transaction History') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg" x-data="{ activeTab: 'transactions' }">
                <div class="p-6 lg:p-8 border-b border-gray-200 dark:border-gray-700">
                    {{-- Tab Navigation --}}
                    <div class="mb-6">
                        <nav class="flex space-x-1" aria-label="Tabs">
                            <button @click="activeTab = 'transactions'"
                                    :class="{
                                        'bg-indigo-100 dark:bg-indigo-700 text-indigo-700 dark:text-indigo-300': activeTab === 'transactions',
                                        'text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700/50': activeTab !== 'transactions'
                                    }"
                                    class="px-4 py-2 font-medium text-sm rounded-md focus:outline-none transition-colors duration-150 ease-in-out">
                                Transaction History
                            </button>
                            <button @click="activeTab = 'withdrawals'"
                                    :class="{
                                        'bg-indigo-100 dark:bg-indigo-700 text-indigo-700 dark:text-indigo-300': activeTab === 'withdrawals',
                                        'text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700/50': activeTab !== 'withdrawals'
                                    }"
                                    class="px-4 py-2 font-medium text-sm rounded-md focus:outline-none transition-colors duration-150 ease-in-out">
                                Withdrawal Requests
                            </button>
                        </nav>
                    </div>

                    @include('layouts.partials.flash-messages')
                </div>

                {{-- Transaction History Content --}}
                <div x-show="activeTab === 'transactions'" class="p-6 lg:p-8">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-6">Transaction History</h3>
                     @if($transactions->isEmpty())
                         <p class="text-center text-gray-500 dark:text-gray-400 py-8">
                             You have no wallet transactions yet.
                         </p>
                     @else
                         <div class="overflow-x-auto">
                             <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                 <thead class="bg-gray-50 dark:bg-gray-700">
                                     <tr>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Date</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Type</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Amount</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Balance After</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Gateway</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Description</th>
                                     </tr>
                                 </thead>
                                 <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                     @foreach ($transactions as $transaction)
                                         <tr>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $transaction->created_at->format('M d, Y H:i') }}</td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-700 dark:text-gray-200">{{ Str::title(str_replace('_', ' ', $transaction->type)) }}</td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold {{ $transaction->amount > 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                 {{ $transaction->amount > 0 ? '+' : '' }}${{ number_format($transaction->amount, 2) }}
                                             </td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">${{ number_format($transaction->balance_after_transaction, 2) }}</td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ Str::title(str_replace('_', ' ', $transaction->payment_gateway ?? 'N/A')) }}</td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ Str::title($transaction->status) }}</td>
                                             <td class="px-6 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $transaction->description }}</td>
                                         </tr>
                                     @endforeach
                                 </tbody>
                             </table>
                         </div>
                         <div class="mt-4">
                             {{ $transactions->links() }}
                         </div>
                     @endif
                </div>

                {{-- Withdrawal Requests Content --}}
                <div x-show="activeTab === 'withdrawals'" class="p-6 lg:p-8" style="display: none;"> {{-- style="display: none;" for initial hide if not active --}}
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-6">Withdrawal Requests</h3>
                     @if($withdrawalRequests->isEmpty())
                         <p class="text-center text-gray-500 dark:text-gray-400 py-8">
                             You have no withdrawal requests yet.
                         </p>
                     @else
                         <div class="overflow-x-auto">
                             <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                 <thead class="bg-gray-50 dark:bg-gray-700">
                                     <tr>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Date</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Amount</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Method</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Status</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Admin Notes</th>
                                         <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Actions</th>
                                     </tr>
                                 </thead>
                                 <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                     @foreach ($withdrawalRequests as $request)
                                         <tr>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ $request->created_at->format('M d, Y H:i') }}</td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm font-semibold text-red-600 dark:text-red-400">
                                                 ${{ number_format($request->amount, 2) }}
                                             </td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">{{ Str::title(str_replace('_', ' ', $request->withdrawal_method)) }}</td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm">
                                                 <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                                     @if($request->status === 'pending') bg-yellow-100 text-yellow-800 dark:bg-yellow-700 dark:text-yellow-100
                                                     @elseif($request->status === 'approved') bg-blue-100 text-blue-800 dark:bg-blue-700 dark:text-blue-100
                                                     @elseif($request->status === 'processing') bg-indigo-100 text-indigo-800 dark:bg-indigo-700 dark:text-indigo-100
                                                     @elseif($request->status === 'completed') bg-green-100 text-green-800 dark:bg-green-700 dark:text-green-100
                                                     @elseif($request->status === 'rejected') bg-red-100 text-red-800 dark:bg-red-700 dark:text-red-100
                                                     @else bg-gray-100 text-gray-800 dark:bg-gray-600 dark:text-gray-200 @endif">
                                                     {{ \App\Models\WalletWithdrawalRequest::getStatuses()[$request->status] ?? Str::title($request->status) }}
                                                 </span>
                                             </td>
                                             <td class="px-6 py-4 text-sm text-gray-500 dark:text-gray-400">{{ $request->admin_notes ?? 'N/A' }}</td>
                                             <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                 <a href="{{ route('wallet.withdrawal-requests.show', $request->id) }}" class="text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">View Details</a>
                                             </td>
                                         </tr>
                                     @endforeach
                                 </tbody>
                             </table>
                         </div>
                         <div class="mt-4">
                             {{ $withdrawalRequests->links('pagination::tailwind', ['pageName' => 'withdrawals_page']) }}
                         </div>
                     @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>