<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Deposit Funds to Wallet') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-2xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-6 lg:p-8">
                    <h3 class="text-2xl font-semibold text-gray-900 dark:text-gray-100 mb-6">
                        Add Funds to Your Wallet
                    </h3>

                    @include('layouts.partials.flash-messages') {{-- Or your specific alert component --}}

                    <div class="mb-6 p-4 border border-blue-200 dark:border-blue-700 bg-blue-50 dark:bg-gray-700/50 rounded-md">
                        <p class="text-sm text-gray-700 dark:text-gray-300">
                            Your Current Wallet Balance:
                            <span class="font-bold text-lg text-blue-600 dark:text-blue-400">
                                ${{ number_format($currentBalance, 2) }}
                            </span>
                        </p>
                    </div>

                    <form action="{{ route('user.wallet.deposit.process') }}" method="POST" id="deposit-form">
                        @csrf

                        <div class="mb-4">
                            <label for="amount" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Amount to Deposit (USD)</label>
                            <input type="number" name="amount" id="amount" step="0.01" min="1.00" value="{{ old('amount', 5.00) }}" required
                                   class="mt-1 block w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm dark:bg-gray-700 dark:text-gray-200">
                            @error('amount') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                        </div>

                        @if(count($paymentGateways) > 0)
                            <div class="mb-6">
                                <label for="payment_method" class="block text-sm font-medium text-gray-700 dark:text-gray-300">Payment Method</label>
                                <select name="payment_method" id="payment_method" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-100 focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm rounded-md">
                                    @foreach($paymentGateways as $key => $gateway)
                                        <option value="{{ $key }}">{{ $gateway['name'] }}</option>
                                    @endforeach
                                </select>
                                @error('payment_method') <p class="mt-1 text-xs text-red-500">{{ $message }}</p> @enderror
                            </div>

                            {{-- Placeholder for payment gateway specific fields (e.g., Stripe Elements, PayPal button) --}}
                            <div id="payment-element-container" class="my-4">
                                <p class="text-gray-500 dark:text-gray-400 text-sm">Payment gateway integration will appear here for the selected method.</p>
                            </div>

                            <button type="submit"
                                    class="w-full bg-green-600 hover:bg-green-700 text-white font-semibold py-3 px-4 rounded-lg text-center transition duration-150 ease-in-out">
                                Proceed to Deposit (Simulated)
                            </button>
                        @else
                             <p class="text-center text-red-500 dark:text-red-400">
                                No payment gateways are currently configured for deposits. Please contact support.
                            </p>
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>