<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Custom Deposit Instructions') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-3xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg">
                <div class="p-6 lg:p-8">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100">
                            {{ __('Payment Instructions') }}
                        </h3>
                        <a href="{{ route('user.wallet.deposit.form') }}" class="text-sm text-indigo-600 hover:text-indigo-900 dark:text-indigo-400 dark:hover:text-indigo-300">
                            &larr; Back to Deposit Form
                        </a>
                    </div>

                    @if($amount)
                        <div class="mb-4 p-3 bg-blue-50 dark:bg-blue-900/50 border border-blue-200 dark:border-blue-700 rounded-md">
                            <p class="text-sm text-blue-700 dark:text-blue-300">
                                You are attempting to deposit: <span class="font-semibold">{{ setting('wallet_default_currency', 'USD') }} {{ number_format($amount, 2) }}</span>.
                            </p>
                        </div>
                    @endif

                    <div class="prose dark:prose-invert max-w-none text-gray-700 dark:text-gray-300">
                        {!! nl2br(e($instructions)) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
