<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Ticket: {{ $ticket->subject }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6 mb-6">
                <div class="mb-4">
                    <h3 class="text-lg font-medium text-gray-900">Ticket Details</h3>
                    <p><strong>Status:</strong> {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}</p>
                    <p><strong>Priority:</strong> {{ ucfirst($ticket->priority) }}</p>
                    <p><strong>Created:</strong> {{ $ticket->created_at->format('M d, Y H:i A') }}</p>
                    <p><strong>Last Reply:</strong> {{ $ticket->last_reply_at ? $ticket->last_reply_at->format('M d, Y H:i A') : 'N/A' }}</p>
                </div>
                <hr class="my-4">
                <div class="prose max-w-none">
                    <p class="font-semibold">Initial Message:</p>
                    {!! nl2br(e($ticket->message)) !!}
                </div>
            </div>

            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6 mb-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Replies</h3>
                @if($ticket->replies->isEmpty())
                    <p>No replies yet.</p>
                @else
                    @foreach($ticket->replies as $reply)
                        <div class="mb-4 p-4 border rounded-md {{ $reply->user_id === Auth::id() ? 'bg-blue-50' : 'bg-gray-50' }}">
                            <p class="font-semibold">{{ $reply->user->name }} <span class="text-xs text-gray-500">({{ $reply->created_at->diffForHumans() }})</span></p>
                            <div class="prose max-w-none mt-1">
                                {!! nl2br(e($reply->message)) !!}
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>

            @if($ticket->status !== 'closed')
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
                <h3 class="text-lg font-medium text-gray-900 mb-4">Submit a Reply</h3>
                <form action="{{ route('user.tickets.reply', $ticket) }}" method="POST">
                    @csrf
                    <div class="mb-4">
                        <label for="message" class="block text-sm font-medium text-gray-700">Your Message</label>
                        <textarea name="message" id="message" rows="5" required
                                  class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">{{ old('message') }}</textarea>
                        @error('message') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
                    </div>
                    <div class="flex items-center justify-end mt-4">
                        <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-500 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring focus:ring-blue-300 disabled:opacity-25 transition">
                            Submit Reply
                        </button>
                    </div>
                </form>
            </div>
            @else
            <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                            <path fill-rule="evenodd" d="M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495zM10 5a.75.75 0 01.75.75v3.5a.75.75 0 01-1.5 0v-3.5A.75.75 0 0110 5zm0 9a1 1 0 100-2 1 1 0 000 2z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-yellow-700">
                            This ticket is closed. If you need further assistance, please <a href="{{ route('user.tickets.create') }}" class="font-medium underline text-yellow-700 hover:text-yellow-600">create a new ticket</a>.
                        </p>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</x-app-layout>