<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('My Support Tickets') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-medium text-gray-900">Your Tickets</h3>
                    <a href="{{ route('user.tickets.create') }}" class="inline-flex items-center px-4 py-2 bg-blue-500 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring focus:ring-blue-300 disabled:opacity-25 transition">
                        Create New Ticket
                    </a>
                </div>

                @if($tickets->isEmpty())
                    <p>You have not created any support tickets yet.</p>
                @else
                    <ul class="divide-y divide-gray-200">
                        @foreach ($tickets as $ticket)
                            <li class="py-4">
                                <a href="{{ route('user.tickets.show', $ticket) }}" class="block hover:bg-gray-50 p-2 rounded">
                                    <div class="flex justify-between">
                                        <span class="font-semibold text-gray-700">{{ $ticket->subject }}</span>
                                        <span class="text-sm text-gray-500">Status: {{ ucfirst(str_replace('_', ' ', $ticket->status)) }}</span>
                                    </div>
                                    <div class="text-sm text-gray-600">
                                        Priority: {{ ucfirst($ticket->priority) }} | Last Reply: {{ $ticket->last_reply_at ? $ticket->last_reply_at->diffForHumans() : 'N/A' }}
                                    </div>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                    <div class="mt-4">
                        {{ $tickets->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>
</x-app-layout>